/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.benchmark;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.benchmark.BenchmarkUnitOfWork;
import com.berryworks.edireader.benchmark.EDITestData;
import com.berryworks.jquantify.EventCounter;
import com.berryworks.jquantify.SessionCounter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class AnsiUnitOfWork
implements BenchmarkUnitOfWork {
    private SessionCounter sessionCounter;
    private EventCounter charCounter;
    private int interchangeKCs;
    private int charCount;

    @Override
    public void run() {
        if (this.sessionCounter == null) {
            throw new RuntimeException("SessionCounter net set");
        }
        PipedWriter pipedWriter = new PipedWriter();
        try {
            PipedReader pipedReader = new PipedReader(pipedWriter);
            this.generateContent(pipedWriter);
            InputSource inputSource = new InputSource(pipedReader);
            EDIReader reader = EDIReaderFactory.createEDIReader(inputSource);
            reader.setContentHandler(new DefaultHandler());
            reader.parse(inputSource);
            this.charCount = reader.getTokenizer().getCharCount();
            this.charCounter.add(this.charCount);
        }
        catch (Exception e) {
            throw new RuntimeException("caught exception", e);
        }
        this.sessionCounter.stop();
    }

    private void generateContent(Writer writer) {
        EDITestData generator = new EDITestData();
        generator.setWriter(writer);
        generator.setInterchangeKCs(this.interchangeKCs);
        new Thread(generator).start();
    }

    @Override
    public int getCharCount() {
        return this.charCount;
    }

    public SessionCounter getSessionCounter() {
        return this.sessionCounter;
    }

    @Override
    public void setSessionCounter(SessionCounter sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public EventCounter getEventCounter() {
        return this.charCounter;
    }

    @Override
    public void setCharCounter(EventCounter charCounter) {
        this.charCounter = charCounter;
    }

    @Override
    public void setInterchangeKCs(int kcs) {
        this.interchangeKCs = kcs;
    }
}

