/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

public class XmlFormatter {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private static final int INDENT_LENGTH = 4;

    public String format(String xmlText) {
        int i;
        Object indent = "";
        int startLookingAtIndex = 0;
        while ((i = ((String)xmlText).indexOf("><", startLookingAtIndex)) >= 0) {
            char peekAhead = ((String)xmlText).charAt(i + 2);
            int delta = this.changeIndent((String)xmlText, i, peekAhead);
            if (delta < 0) {
                switch (((String)indent).length()) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        indent = "";
                        break;
                    }
                    default: {
                        indent = ((String)indent).substring(INDENT.length());
                        break;
                    }
                }
            } else if (delta > 0) {
                indent = (String)indent + INDENT;
            }
            String insertedWhitespace = SEPARATOR + (String)indent;
            xmlText = ((String)xmlText).substring(0, i + 1) + insertedWhitespace + ((String)xmlText).substring(i + 1);
            startLookingAtIndex = i + insertedWhitespace.length() + 1;
        }
        return xmlText;
    }

    private int changeIndent(String xmlText, int startingIndex, char peekAhead) {
        int index = startingIndex;
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return 1;
                }
                case '?': {
                    return 0;
                }
                case '/': {
                    if (index + 1 == startingIndex) {
                        return -1;
                    }
                    return peekAhead == '/' ? -1 : 0;
                }
            }
        }
        return 0;
    }

    private char priorNonWhitespace(String xmlText, int index) {
        char c;
        do {
            if (--index > 0) continue;
            return xmlText.charAt(0);
        } while (Character.isWhitespace(c = xmlText.charAt(index)));
        return c;
    }

    private boolean isClosing(String xmlText, int index) {
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return false;
                }
                case '/': 
                case '?': {
                    return true;
                }
            }
        }
        return false;
    }
}

