/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.dom;

import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.util.sax.ContextAwareSaxAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DomBuildingSaxHandler
extends ContextAwareSaxAdapter {
    private Document document;
    private Element currentElement;

    public DomBuildingSaxHandler() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void start(String uri, String name, String data, EDIAttributes attributes) throws SAXException {
        Element newElement = this.document.createElement(name);
        if (this.currentElement == null) {
            this.document.appendChild(newElement);
        } else {
            this.currentElement.appendChild(newElement);
        }
        this.currentElement = newElement;
        if (data != null && data.length() > 0) {
            Text text = this.document.createTextNode(data);
            this.currentElement.appendChild(text);
        }
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String n = attributes.getLocalName(i);
                String v = attributes.getValue(i);
                this.currentElement.setAttribute(n, v);
            }
        }
    }

    @Override
    public void end(String uri, String name) throws SAXException {
        Node parentNode = this.currentElement.getParentNode();
        if (parentNode instanceof Element) {
            this.currentElement = (Element)parentNode;
        }
    }
}

