/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.EDIAttributes;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueuedContentHandler
extends DefaultHandler {
    private final ContentHandler wrappedHandler;
    private final LinkedList<QueuedItem> queue = new LinkedList();
    private final int queueSizeLimit;

    public QueuedContentHandler(ContentHandler handler, int queueSizeLimit) {
        this.wrappedHandler = handler;
        this.queueSizeLimit = queueSizeLimit;
    }

    @Override
    public void startDocument() throws SAXException {
        this.wrappedHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.drainQueue();
        this.wrappedHandler.endDocument();
    }

    private void drainQueue() throws SAXException {
        while (this.queue.size() > 0) {
            this.queue.removeFirst().process(this.wrappedHandler);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.limitSize();
        this.queue.add(new QueuedStartItem(uri, localName, qName, attributes));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.limitSize();
        this.queue.add(new QueuedEndItem(uri, localName, qName));
    }

    private void limitSize() throws SAXException {
        while (this.queue.size() >= this.queueSizeLimit) {
            this.queue.removeFirst().process(this.wrappedHandler);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.characters(new String(chars, start, length));
    }

    public void characters(String data) {
        this.queue.getLast().addData(data);
    }

    public void putAttribute(String tag, String attributeName, String data) {
        for (int i = this.queue.size() - 1; i >= 0; --i) {
            QueuedItem queuedItem = this.queue.get(i);
            if (!tag.equals(queuedItem.getLocalName())) continue;
            EDIAttributes attributes = queuedItem.getAttributes();
            int index = attributes.getIndex(attributeName);
            if (index >= 0) {
                attributes.removeAttribute(index);
            }
            attributes.addCDATA(attributeName, data);
            return;
        }
        throw new RuntimeException("Could not find queued element " + tag + " for putAttribute()");
    }

    EDIAttributes getFirstAttributes() {
        if (this.queue.size() == 0) {
            return null;
        }
        return this.queue.getFirst().getAttributes();
    }

    class QueuedEndItem
    extends QueuedItem {
        QueuedEndItem(String uri, String localName, String qName) {
            super(uri, localName, qName);
        }

        @Override
        public void process(ContentHandler handler) throws SAXException {
            handler.endElement(this.getUri(), this.getLocalName(), this.getQName());
        }

        @Override
        public void addData(String data) {
            throw new RuntimeException("addData() should not be called on an end item");
        }

        @Override
        public EDIAttributes getAttributes() {
            throw new RuntimeException("getAttributes() should not be called on an end item");
        }
    }

    class QueuedStartItem
    extends QueuedItem {
        private final EDIAttributes attributes;
        private String data;

        QueuedStartItem(String uri, String localName, String qName, Attributes attributes) {
            super(uri, localName, qName);
            this.attributes = new EDIAttributes(attributes);
        }

        @Override
        public EDIAttributes getAttributes() {
            return this.attributes;
        }

        public String getData() {
            return this.data;
        }

        @Override
        public void addData(String data) {
            this.data = this.data == null ? data : this.data + data;
        }

        @Override
        public void process(ContentHandler handler) throws SAXException {
            EDIAttributes attributes1 = this.getAttributes();
            if (attributes1 == null) {
                throw new RuntimeException("null attributes");
            }
            String name = this.getLocalName();
            if (name == null) {
                throw new RuntimeException("null name");
            }
            String qname = this.getQName();
            if (qname == null) {
                throw new RuntimeException("null qname");
            }
            String uri = this.getUri();
            if (uri == null) {
                throw new RuntimeException("null uri");
            }
            handler.startElement(uri, name, qname, attributes1);
            if (this.getData() != null) {
                char[] ca = this.getData().toCharArray();
                handler.characters(ca, 0, ca.length);
            }
        }
    }

    abstract class QueuedItem {
        private final String uri;
        private final String localName;
        private final String qName;

        QueuedItem(String uri, String localName, String qName) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
        }

        public String getUri() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getQName() {
            return this.qName;
        }

        public void end(ContentHandler handler) throws SAXException {
            handler.endElement(this.uri, this.localName, this.qName);
        }

        public abstract void process(ContentHandler var1) throws SAXException;

        public abstract void addData(String var1);

        public abstract EDIAttributes getAttributes();
    }
}

