/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EbfEdiScanner {
    private static Logger log = Logger.getLogger(EbfEdiScanner.class);
    private EdifactData edifactData = new EdifactData();
    private EDIReader parser;
    private InputSource inputSource;

    public EbfEdiScanner(String input) {
        if (input != null) {
            try {
                this.inputSource = new InputSource(new FileReader(input));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public EdifactData getEdifactData() {
        return this.edifactData;
    }

    public void run() {
        DefaultHandler handler = new DefaultHandler();
        char[] preRead = null;
        try {
            while (true) {
                this.parser = EDIReaderFactory.createEDIReader(this.inputSource, preRead);
                if (this.parser != null) {
                    this.parser.setTempEdifactData(this.edifactData);
                    this.parser.setContentHandler(handler);
                    this.parser.parse(this.inputSource);
                    this.edifactData = this.parser.getTempEdifactData();
                    preRead = this.parser.getTokenizer().getBuffered();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (SAXException syntaxException) {
            log.error((Object)("Unrecoverable syntax exception: " + syntaxException.getClass().getCanonicalName() + " - " + syntaxException.getMessage()));
            Tokenizer ediTokenizer = this.parser.getTokenizer();
            log.error((Object)"Informaci\u00f3n de la EDIReader");
            char delimiter = ediTokenizer.getDelimiter();
            log.error((Object)("Field delimiter: " + this.representationOf(delimiter)));
            char terminator = ediTokenizer.getTerminator();
            log.error((Object)("Segment terminator: " + this.representationOf(terminator)));
            throw new RuntimeException(syntaxException.getMessage());
        }
    }

    private String representationOf(char c) {
        String result = "|" + c + "|";
        result = result + " (" + c + ")";
        return result;
    }
}

