/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.SyntaxDescriptor;
import com.berryworks.edireader.util.BranchingWriter;
import com.berryworks.edireader.util.DateTimeGenerator;
import java.io.IOException;

public class AnsiFAGenerator
extends ReplyGenerator {
    private final BranchingWriter ackStream;
    private boolean preambleGenerated;
    private boolean skipFA;
    private final String thisGroupControlNumber;
    private int thisDocumentCount;
    private String referencedISA;
    private boolean headerGenerated;
    private boolean groupTrailerGenerated;
    private char delimiter;
    private String terminatorWithSuffix;
    private static final String CONTROL_NUMBER_997 = "0001";

    public AnsiFAGenerator(StandardReader ansiReader, BranchingWriter ackStream) {
        this.standardReader = ansiReader;
        this.ackStream = ackStream;
        this.thisGroupControlNumber = "12345";
    }

    @Override
    public void generateAcknowledgmentHeader(String firstSegment, String groupSender, String groupReceiver, int groupDateLength, String groupVersion, String groupFunctionCode, String groupControlNumber) throws IOException {
        if (this.ackStream == null) {
            return;
        }
        if ("FA".equals(groupFunctionCode)) {
            this.skipFA = true;
            return;
        }
        this.skipFA = false;
        if (EDIReader.debug) {
            EDIReader.trace("generating FA envelope");
        }
        this.generateAcknowledgementPreamble(firstSegment, groupSender, groupReceiver, groupDateLength, groupVersion);
        if (EDIReader.debug) {
            EDIReader.trace("generating first part of 997");
        }
        ++this.thisDocumentCount;
        this.ackStream.write("ST" + this.delimiter + "997" + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.write("AK1" + this.delimiter + groupFunctionCode + this.delimiter + groupControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        this.headerGenerated = true;
    }

    @Override
    public void generateTransactionAcknowledgment(String transactionCode, String controlNumber) throws IOException {
        if (this.ackStream == null || this.skipFA) {
            return;
        }
        if (EDIReader.debug) {
            EDIReader.trace("generating AK2/AK5");
        }
        this.ackStream.writeTrunk("AK2" + this.delimiter + transactionCode + this.delimiter + controlNumber);
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
        this.ackStream.writeTrunk("AK5" + this.delimiter + "A");
        this.ackStream.writeTrunk(this.terminatorWithSuffix);
    }

    @Override
    public void generateGroupAcknowledgmentTrailer(int docCount) throws IOException {
        if (this.ackStream == null || this.skipFA) {
            return;
        }
        if (EDIReader.debug) {
            EDIReader.trace("generating AK9, SE");
        }
        this.ackStream.writeTrunk("AK9" + this.delimiter + "A" + this.delimiter + docCount + this.delimiter + docCount + this.delimiter + docCount);
        this.ackStream.writeBranch("AK9" + this.delimiter + "R" + this.delimiter + docCount + this.delimiter + docCount + this.delimiter + "0");
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.writeTrunk("SE" + this.delimiter + (4 + 2 * docCount) + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.writeBranch("SE" + this.delimiter + "4" + this.delimiter + CONTROL_NUMBER_997);
        this.ackStream.write(this.terminatorWithSuffix);
        this.groupTrailerGenerated = true;
    }

    @Override
    public void generateNegativeACK() throws IOException {
        if (this.ackStream == null || this.skipFA || !this.headerGenerated) {
            return;
        }
        if (EDIReader.debug) {
            EDIReader.trace("recasting 997 as negative");
        }
        if (!this.groupTrailerGenerated) {
            this.generateGroupAcknowledgmentTrailer(0);
        }
        this.generateAcknowledgementWrapup(false);
    }

    @Override
    public void generateAcknowledgementWrapup() throws IOException {
        this.generateAcknowledgementWrapup(true);
    }

    public void generateAcknowledgementWrapup(boolean positiveFA) throws IOException {
        if (this.ackStream == null || this.skipFA) {
            return;
        }
        if (EDIReader.debug) {
            EDIReader.trace("generating GE, IEA");
        }
        this.ackStream.write("GE" + this.delimiter + this.thisDocumentCount + this.delimiter + this.thisGroupControlNumber);
        this.ackStream.write(this.terminatorWithSuffix);
        this.ackStream.write("IEA" + this.delimiter + "1" + this.delimiter + this.referencedISA.substring(90, 99));
        this.ackStream.write(this.terminatorWithSuffix);
        if (positiveFA) {
            this.ackStream.close();
        } else {
            this.ackStream.closeUsingBranch();
        }
    }

    private void generateAcknowledgementPreamble(String firstSegment, String groupSender, String groupReceiver, int groupDateLength, String groupVersion) throws IOException {
        if (this.ackStream == null || this.preambleGenerated) {
            return;
        }
        this.referencedISA = firstSegment;
        this.establishSyntaxCharacters();
        String sender = firstSegment.substring(51, 70);
        String receiver = firstSegment.substring(32, 51);
        Object faHeader = firstSegment.substring(0, 32) + sender + receiver + DateTimeGenerator.generate(this.delimiter) + firstSegment.substring(81, firstSegment.length() - 1);
        char senderDelimiter = this.standardReader.getDelimiter();
        if (senderDelimiter != this.delimiter) {
            faHeader = ((String)faHeader).replace(senderDelimiter, this.delimiter);
        }
        this.ackStream.write((String)faHeader);
        this.ackStream.write(this.terminatorWithSuffix);
        if (this.standardReader.isInterchangeAcknowledgment()) {
            this.ackStream.write("TA1" + this.delimiter + firstSegment.substring(90, 99) + this.delimiter + firstSegment.substring(70, 76) + this.delimiter + firstSegment.substring(77, 81) + this.delimiter);
            this.ackStream.writeTrunk("A" + this.delimiter + "000");
            this.ackStream.writeBranch("R" + this.delimiter + "022");
            this.ackStream.write(this.terminatorWithSuffix);
        }
        this.ackStream.write("GS" + this.delimiter + "FA" + this.delimiter + groupReceiver + this.delimiter + groupSender + this.delimiter + this.controlDateAndTime(groupDateLength, this.delimiter) + this.delimiter + this.thisGroupControlNumber + this.delimiter + "X" + this.delimiter + groupVersion);
        this.ackStream.write(this.terminatorWithSuffix);
        this.preambleGenerated = true;
    }

    private void establishSyntaxCharacters() {
        SyntaxDescriptor sd = this.standardReader.getAcknowledgmentSyntaxDescriptor();
        char terminator = '\u0000';
        String terminatorSuffix = null;
        if (sd == null) {
            this.delimiter = '\u0000';
        } else {
            this.delimiter = sd.getDelimiter();
            terminator = sd.getTerminator();
            terminatorSuffix = sd.getTerminatorSuffix();
        }
        if (this.delimiter == '\u0000') {
            this.delimiter = this.standardReader.getDelimiter();
        }
        if (terminator == '\u0000') {
            terminator = this.standardReader.getTerminator();
        }
        if (terminatorSuffix == null) {
            terminatorSuffix = this.standardReader.getTerminatorSuffix();
        }
        this.terminatorWithSuffix = terminator + terminatorSuffix;
    }

    @Override
    public void generateAcknowledgmentHeader(String syntaxIdentifier, String syntaxVersionNumber, String fromId, String fromQual, String toId, String toQual, String interchangeControlNumber) {
    }
}

