/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIParserFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class EDITransform {
    private InputSource inputSource;
    private final StreamSource stylesheetSource;
    private OutputStream generatedOutput;

    public EDITransform(String input, String stylesheet, String output) {
        if (input != null) {
            try {
                this.inputSource = new InputSource(new FileReader(input));
                System.out.println("Input file " + input + " opened");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.inputSource = new InputSource(new InputStreamReader(System.in));
        }
        if (output != null) {
            try {
                this.generatedOutput = new BufferedOutputStream(new FileOutputStream(output));
                System.out.println("Output file " + output + " opened");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.generatedOutput = System.out;
        }
        this.stylesheetSource = new StreamSource(new File(stylesheet));
        System.out.println("Stylesheet file " + stylesheet + " opened");
    }

    public void run() {
        try {
            SAXParserFactory sFactory = EDIParserFactory.newInstance();
            SAXParser sParser = sFactory.newSAXParser();
            XMLReader ediReader = sParser.getXMLReader();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                String msg = "TransformerFactory " + tFactory.getClass().getName() + " does not support SAXTransformerFactory";
                System.err.println(msg);
                throw new RuntimeException(msg);
            }
            SAXTransformerFactory stFactory = (SAXTransformerFactory)tFactory;
            TransformerHandler transformerHandler = stFactory.newTransformerHandler(this.stylesheetSource);
            transformerHandler.setResult(new StreamResult(this.generatedOutput));
            ediReader.setContentHandler(transformerHandler);
            ediReader.parse(this.inputSource);
        }
        catch (SAXException e) {
            System.out.println("\nUnable to create SAXParser: " + e);
        }
        catch (IOException e) {
            System.out.println("\nUnable to create EDIReader: " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("\nUnable to create Parser: " + e);
        }
        catch (TransformerConfigurationException e) {
            System.out.println("\nUnable to create Transformer: " + e);
        }
    }

    public static void main(String[] args) {
        String outputFileName = null;
        String stylesheetFileName = null;
        String inputFileName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    EDITransform.badArgs();
                }
                outputFileName = args[i];
                continue;
            }
            if (args[i].equals("-x")) {
                if (++i >= args.length) {
                    EDITransform.badArgs();
                }
                stylesheetFileName = args[i];
                continue;
            }
            inputFileName = args[i];
        }
        if (stylesheetFileName == null) {
            EDITransform.badArgs();
        }
        EDITransform theObject = new EDITransform(inputFileName, stylesheetFileName, outputFileName);
        theObject.run();
        String s = System.getProperty("line.separator");
        System.out.print(s + "Transformation complete" + s);
    }

    private static void badArgs() {
        System.out.println("Usage: EDITransform  [inputfile] [-x stylesheet] [-o outputfile] ");
        throw new RuntimeException("Missing or invalid command line arguments");
    }
}

