/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.splitter;

import com.berryworks.edireader.DefaultXMLTags;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.splitter.HandlerFactory;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SplittingHandler
extends DefaultHandler {
    private final HandlerFactory handlerFactory;
    private ContentHandler contentHandler;
    private boolean pendingDocumentClose;
    private boolean senderAddress;
    private Attributes interchangeAttributes;
    private Attributes senderAttributes;
    private Attributes receiverAttributes;
    private Attributes groupAttributes;
    private final Attributes emptyAttributes = new AttributesImpl();
    private final String interchangeTagName = DefaultXMLTags.getInstance().getInterchangeTag();
    private final String senderTagName = DefaultXMLTags.getInstance().getSenderTag();
    private final String receiverTagName = DefaultXMLTags.getInstance().getReceiverTag();
    private final String addressTagName = DefaultXMLTags.getInstance().getAddressTag();

    public SplittingHandler(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public void split(InputSource inputSource) throws IOException, SAXException {
        EDIReader parser;
        char[] leftOver = null;
        while ((parser = EDIReaderFactory.createEDIReader(inputSource, leftOver)) != null) {
            parser.setContentHandler(this);
            parser.parse(inputSource);
            leftOver = parser.getTokenizer().getBuffered();
        }
        this.handlerFactory.markEndOfStream();
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.contentHandler = this.handlerFactory.createDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
        try {
            this.handlerFactory.closeDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (DefaultXMLTags.getInstance().getInterchangeTag().equals(localName)) {
            this.interchangeAttributes = new EDIAttributes(attributes);
        } else if (DefaultXMLTags.getInstance().getSenderTag().equals(localName)) {
            this.senderAddress = true;
        } else if (DefaultXMLTags.getInstance().getReceiverTag().equals(localName)) {
            this.senderAddress = false;
        } else if (DefaultXMLTags.getInstance().getAddressTag().equals(localName)) {
            if (this.senderAddress) {
                this.senderAttributes = new EDIAttributes(attributes);
            } else {
                this.receiverAttributes = new EDIAttributes(attributes);
            }
        } else if (DefaultXMLTags.getInstance().getGroupTag().equals(localName)) {
            if (this.pendingDocumentClose) {
                this.generateArtificialBoundaryForNewGroup();
                this.pendingDocumentClose = false;
            }
            this.groupAttributes = attributes;
        } else if (DefaultXMLTags.getInstance().getDocumentTag().equals(localName) && this.pendingDocumentClose) {
            this.generateArtificialBoundaryForNewDocument();
            this.pendingDocumentClose = false;
        }
        this.contentHandler.startElement(uri, localName, qName, attributes);
    }

    private void generateArtificialBoundaryForNewDocument() throws SAXException {
        this.pendingDocumentClose = false;
        String groupTagName = DefaultXMLTags.getInstance().getGroupTag();
        this.endElement("", groupTagName, groupTagName);
        this.generateArtificialBoundaryForNewGroup();
        this.startElement("", groupTagName, groupTagName, this.groupAttributes);
    }

    private void generateArtificialBoundaryForNewGroup() throws SAXException {
        this.pendingDocumentClose = false;
        this.endElement("", this.interchangeTagName, this.interchangeTagName);
        String rootTagName = DefaultXMLTags.getInstance().getRootTag();
        this.endElement("", rootTagName, rootTagName);
        this.endDocument();
        this.startDocument();
        this.startElement("", rootTagName, rootTagName, this.emptyAttributes);
        this.startElement("", this.interchangeTagName, this.interchangeTagName, this.interchangeAttributes);
        this.startElement("", this.senderTagName, this.senderTagName, this.emptyAttributes);
        this.startElement("", this.addressTagName, this.addressTagName, this.senderAttributes);
        this.endElement("", this.addressTagName, this.addressTagName);
        this.endElement("", this.senderTagName, this.senderTagName);
        this.startElement("", this.receiverTagName, this.receiverTagName, this.emptyAttributes);
        this.startElement("", this.addressTagName, this.addressTagName, this.receiverAttributes);
        this.endElement("", this.addressTagName, this.addressTagName);
        this.endElement("", this.receiverTagName, this.receiverTagName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
        if (DefaultXMLTags.getInstance().getDocumentTag().equals(localName)) {
            this.pendingDocumentClose = true;
        } else if (DefaultXMLTags.getInstance().getInterchangeTag().equals(localName)) {
            this.pendingDocumentClose = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }
}

