/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.tokenizer;

import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.error.ErrorMessages;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public abstract class AbstractTokenizer
implements Tokenizer,
ErrorMessages {
    protected CharacterClass cClass;
    protected State state;
    protected Writer outputWriter = null;
    protected boolean writingSuspended;
    protected final StringBuilder recording = new StringBuilder();
    protected boolean recorderOn;
    protected int segmentCount;
    protected int segTokenCount;
    protected int charCount;
    protected int segCharCount;
    protected final Reader inputReader;
    protected char delimiter = (char)43;
    protected char subDelimiter = (char)58;
    protected char subSubDelimiter = (char)38;
    protected int release = -1;
    protected int repetitionSeparator = -1;
    protected char terminator = (char)46;
    protected boolean tokenReady;
    protected boolean repetition;
    protected boolean endOfFile;
    protected final TokenImpl currentToken;
    protected char cChar;
    protected boolean unGot;

    @Override
    public int getSegmentCount() {
        return this.segmentCount;
    }

    @Override
    public int getElementInSegmentCount() {
        return this.segTokenCount;
    }

    @Override
    public int getCharCount() {
        return this.charCount;
    }

    @Override
    public int getSegmentCharCount() {
        return this.segCharCount;
    }

    @Override
    public Reader getReader() {
        return this.inputReader;
    }

    @Override
    public char getSubSubDelimiter() {
        return this.subSubDelimiter;
    }

    @Override
    public void setSubSubDelimiter(char ssd) {
        this.subSubDelimiter = ssd;
    }

    @Override
    public void setRelease(int e) {
        this.release = e;
    }

    @Override
    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    @Override
    public void setRepetitionSeparator(int e) {
        this.repetitionSeparator = e > 0 ? e : -1;
    }

    @Override
    public void setTerminator(char d) {
        this.terminator = d;
    }

    @Override
    public char getTerminator() {
        return this.terminator;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setDelimiter(char d) {
        this.delimiter = d;
    }

    @Override
    public char getSubDelimiter() {
        return this.subDelimiter;
    }

    @Override
    public void setSubDelimiter(char sd) {
        this.subDelimiter = sd;
    }

    public void copy(char c) {
        if (this.outputWriter != null) {
            try {
                this.outputWriter.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEndOfData() {
        return this.endOfFile;
    }

    @Override
    public String nextSimpleValue(boolean required, boolean returnNullAtSegmentEnd) throws SAXException, IOException {
        Token t = this.nextToken();
        switch (t.getType()) {
            case EMPTY: {
                if (!required) break;
                throw new EDISyntaxException("Mandatory element missing in " + t.getSegmentType() + " segment", this);
            }
            case SEGMENT_END: {
                if (required) {
                    throw new EDISyntaxException("Mandatory element missing in " + t.getSegmentType() + " segment", this);
                }
                if (!returnNullAtSegmentEnd) break;
                return null;
            }
            case SIMPLE: {
                break;
            }
            default: {
                throw new EDISyntaxException("Expected a simple token", this);
            }
        }
        return t.getValue();
    }

    @Override
    public String nextSimpleValue(boolean required) throws SAXException, IOException {
        return this.nextSimpleValue(required, false);
    }

    @Override
    public String nextSimpleValue() throws SAXException, IOException {
        return this.nextSimpleValue(true);
    }

    @Override
    public int nextIntValue() throws SAXException, IOException {
        int i;
        try {
            i = Integer.parseInt(this.nextSimpleValue());
        }
        catch (NumberFormatException e) {
            throw new EDISyntaxException("Element must contain only digits", this);
        }
        return i;
    }

    @Override
    public List<String> nextCompositeElement() throws IOException, EDISyntaxException {
        return this.nextCompositeElement(false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> nextCompositeElement(boolean returnNullAtSegmentEnd) throws IOException, EDISyntaxException {
        result = new ArrayList<String>();
        block7: while (true) lbl-1000:
        // 3 sources

        {
            t = this.nextToken();
            switch (1.$SwitchMap$com$berryworks$edireader$tokenizer$Token$TokenType[t.getType().ordinal()]) {
                case 4: {
                    result.add(t.getValue());
                    if (!t.isLast()) ** GOTO lbl-1000
                    break block7;
                }
                case 5: {
                    result.add("");
                    if (!t.isLast()) continue block7;
                    break block7;
                }
                case 3: {
                    result.add(t.getValue());
                    break block7;
                }
                case 1: {
                    break block7;
                }
                case 2: {
                    if (!returnNullAtSegmentEnd) break block7;
                    return null;
                }
                default: {
                    throw new EDISyntaxException("Invalid composite element", this);
                }
            }
            break;
        }
        return result;
    }

    @Override
    public void ungetToken() {
        this.tokenReady = true;
    }

    @Override
    public void ungetChar() {
        this.unGot = true;
        --this.charCount;
        --this.segCharCount;
    }

    @Override
    public Token nextToken() throws IOException, EDISyntaxException {
        if (!this.tokenReady) {
            this.advance();
        }
        this.tokenReady = false;
        return this.currentToken;
    }

    @Override
    public boolean hasMoreTokens() throws IOException, EDISyntaxException {
        if (!this.tokenReady) {
            this.advance();
        }
        return this.tokenReady;
    }

    @Override
    public String nextSegment() throws SAXException, IOException {
        Token t;
        Token.TokenType tokenType;
        int i = 0;
        while ((tokenType = (t = this.nextToken()).getType()) != Token.TokenType.SEGMENT_START) {
            if (tokenType == Token.TokenType.END_OF_DATA) {
                throw new EDISyntaxException("Unexpected end of data", this);
            }
            if (++i <= 30) continue;
            throw new EDISyntaxException("Too many fields for " + t.getSegmentType() + " segment (Segment terminator problem?)", this);
        }
        return t.getSegmentType();
    }

    @Override
    public Token skipSegment() throws SAXException, IOException {
        Token t;
        Token.TokenType tokenType;
        int i = 0;
        while ((tokenType = (t = this.nextToken()).getType()) != Token.TokenType.SEGMENT_END && tokenType != Token.TokenType.END_OF_DATA) {
            if (++i <= 30) continue;
            throw new EDISyntaxException("Too many fields in " + t.getSegmentType() + " segment", this);
        }
        return t;
    }

    protected CharacterClass scanData(int limit) throws IOException, EDISyntaxException {
        block7: while (true) {
            this.getChar();
            switch (this.cClass) {
                case RELEASE: {
                    this.getChar();
                }
                case DATA: {
                    if (--limit == 0) {
                        throw new EDISyntaxException("Too many characters in an element (delimiter problem?)", this);
                    }
                    this.currentToken.value.append(this.cChar);
                    continue block7;
                }
                case SUB_DELIMITER: {
                    break block7;
                }
                case REPEAT_DELIMITER: {
                    this.repetition = true;
                    break block7;
                }
                case TERMINATOR: {
                    this.ungetChar();
                }
                default: {
                    this.repetition = false;
                    break block7;
                }
            }
            break;
        }
        return this.cClass;
    }

    protected CharacterClass scanData() throws IOException, EDISyntaxException {
        return this.scanData(0);
    }

    @Override
    public void scanTerminatorSuffix() throws IOException {
        do {
            this.getChar();
        } while (this.cClass != CharacterClass.EOF && "\n\r \\".indexOf(this.cChar) != -1);
        this.ungetChar();
    }

    @Override
    public char[] getChars(int n) throws IOException, EDISyntaxException {
        char[] result = new char[n];
        for (int i = 0; i < n; ++i) {
            this.getChar();
            if (this.cClass == CharacterClass.EOF) {
                throw new EDISyntaxException("Encountered end of data unexpectedly after reading " + i + " characters of an expected " + n + " character sequence");
            }
            result[i] = this.cChar;
        }
        return result;
    }

    @Override
    public void setWriter(Writer writer) {
        this.outputWriter = writer;
    }

    @Override
    public String getRecording() {
        return this.recording.toString();
    }

    protected void trace(String string) {
        EDIAbstractReader.trace(string);
    }

    public void suspendWriting(boolean b) {
        this.writingSuspended = b;
    }

    @Override
    public void setRecorder(boolean b) {
        this.recorderOn = b;
        if (EDIReader.debug) {
            this.trace("recorder turned " + (b ? "on" : "off"));
        }
    }

    public AbstractTokenizer(Reader source) {
        this.state = State.EXPECTING_SEGMENT;
        this.inputReader = source;
        this.tokenReady = false;
        this.currentToken = new TokenImpl(this);
    }

    protected void advance() throws IOException, EDISyntaxException {
        this.getChar();
        this.tokenReady = true;
        block0 : switch (this.cClass) {
            case RELEASE: {
                this.getChar();
            }
            case DATA: {
                switch (this.state) {
                    case IN_SEGMENT: {
                        ++this.segTokenCount;
                        this.currentToken.type = Token.TokenType.SIMPLE;
                        this.currentToken.value.setLength(1);
                        this.currentToken.value.setCharAt(0, this.cChar);
                        if (!this.repetition) {
                            ++this.currentToken.index;
                        }
                        this.currentToken.subElementIndex = 0;
                        if (this.scanData() != CharacterClass.SUB_DELIMITER) break;
                        this.currentToken.type = Token.TokenType.SUB_ELEMENT;
                        this.currentToken.lastSubElement = false;
                        this.state = State.IN_COMPOSITE;
                        break;
                    }
                    case IN_COMPOSITE: {
                        ++this.segTokenCount;
                        this.currentToken.type = Token.TokenType.SUB_ELEMENT;
                        ++this.currentToken.subElementIndex;
                        this.currentToken.value.setLength(1);
                        this.currentToken.value.setCharAt(0, this.cChar);
                        if (this.scanData() == CharacterClass.SUB_DELIMITER) break;
                        this.state = State.IN_SEGMENT;
                        this.currentToken.lastSubElement = true;
                        break;
                    }
                    default: {
                        ++this.segmentCount;
                        this.segTokenCount = 1;
                        this.segCharCount = 1;
                        this.currentToken.type = Token.TokenType.SEGMENT_START;
                        this.currentToken.value.setLength(1);
                        this.currentToken.value.setCharAt(0, this.cChar);
                        this.currentToken.index = 0;
                        this.currentToken.subElementIndex = 0;
                        this.scanData(10);
                        this.currentToken.setSegmentType(this.currentToken.value);
                        this.state = State.IN_SEGMENT;
                        break;
                    }
                }
                break;
            }
            case TERMINATOR: {
                switch (this.state) {
                    case IN_COMPOSITE: {
                        ++this.currentToken.subElementIndex;
                        this.currentToken.lastSubElement = true;
                        this.currentToken.type = Token.TokenType.SUB_EMPTY;
                        this.currentToken.value.setLength(0);
                        this.ungetChar();
                        this.state = State.IN_SEGMENT;
                        break block0;
                    }
                }
                this.currentToken.type = Token.TokenType.SEGMENT_END;
                this.state = State.EXPECTING_SEGMENT;
                this.scanTerminatorSuffix();
                this.currentToken.subElementIndex = 0;
                break;
            }
            case DELIMITER: {
                switch (this.state) {
                    case IN_COMPOSITE: {
                        ++this.currentToken.subElementIndex;
                        this.currentToken.type = Token.TokenType.SUB_EMPTY;
                        this.state = State.IN_SEGMENT;
                        break;
                    }
                    default: {
                        ++this.segTokenCount;
                        ++this.currentToken.index;
                        this.currentToken.subElementIndex = 0;
                        this.currentToken.type = Token.TokenType.EMPTY;
                    }
                }
                this.currentToken.lastSubElement = true;
                this.currentToken.value.setLength(0);
                break;
            }
            case SUB_DELIMITER: {
                switch (this.state) {
                    case IN_SEGMENT: {
                        if (!this.repetition) {
                            ++this.currentToken.index;
                        }
                        this.state = State.IN_COMPOSITE;
                        this.currentToken.subElementIndex = 0;
                        break;
                    }
                    case IN_COMPOSITE: {
                        ++this.currentToken.subElementIndex;
                    }
                }
                this.currentToken.lastSubElement = false;
                this.currentToken.type = Token.TokenType.SUB_EMPTY;
                this.currentToken.value.setLength(0);
                break;
            }
            case EOF: {
                this.currentToken.type = Token.TokenType.END_OF_DATA;
                this.tokenReady = false;
                break;
            }
        }
    }

    protected static class TokenImpl
    implements Token {
        final Tokenizer tokenizer;
        Token.TokenType type = Token.TokenType.UNKNOWN;
        int index;
        int subElementIndex;
        boolean lastSubElement;
        StringBuilder value;
        private String segmentType = "";
        private final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        public TokenImpl(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            if (this.value == null) {
                this.value = new StringBuilder();
            } else {
                this.value.setLength(0);
            }
        }

        @Override
        public Token.TokenType getType() {
            return this.type;
        }

        @Override
        public boolean isFirst() {
            return this.subElementIndex == 0;
        }

        @Override
        public boolean isLast() {
            return this.lastSubElement;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getSubIndex() {
            return this.subElementIndex;
        }

        @Override
        public String getValue() {
            return this.value.toString();
        }

        @Override
        public char[] getValueChars() {
            char[] ca = new char[this.value.length()];
            this.value.getChars(0, this.value.length(), ca, 0);
            return ca;
        }

        @Override
        public boolean valueEquals(String v) {
            return this.value.toString().equals(v);
        }

        @Override
        public String getSegmentType() {
            return this.segmentType;
        }

        public void setSegmentType(StringBuilder sb) throws EDISyntaxException {
            this.segmentType = new String(sb);
            if ("".equals(this.segmentType)) {
                throw new EDISyntaxException("Invalid beginning of segment", this.tokenizer);
            }
        }

        @Override
        public Token[] getSubTokens() {
            return null;
        }

        public String toString() {
            return "Token type=" + (Object)((Object)this.getType()) + " value=" + this.getValue() + " index=" + this.getIndex() + " segment=" + this.getSegmentType();
        }

        @Override
        public String getElementId() {
            StringBuilder rval = new StringBuilder(this.getSegmentType());
            int n = this.getIndex();
            if (n < 10) {
                rval.append('0');
                rval.append(this.digits[n]);
            } else {
                rval.append(String.valueOf(n));
            }
            return rval.toString();
        }
    }

    protected static enum CharacterClass {
        DATA,
        DELIMITER,
        SUB_DELIMITER,
        RELEASE,
        TERMINATOR,
        REPEAT_DELIMITER,
        EOF;

    }

    protected static enum State {
        EXPECTING_SEGMENT,
        IN_SEGMENT,
        IN_COMPOSITE;

    }
}

