/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.dom;

import com.berryworks.edireader.EDIReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DocumentUtil {
    private static final DocumentUtil instance = new DocumentUtil();

    private DocumentUtil() {
    }

    public static DocumentUtil getInstance() {
        return instance;
    }

    public synchronized Document buildDocumentFromEdi(InputSource inputSource) throws Exception {
        EDIReader ediReader = new EDIReader();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(new SAXSource(ediReader, inputSource), domResult);
        Document document = (Document)domResult.getNode();
        if (document == null) {
            throw new RuntimeException("transform produced null document");
        }
        return document;
    }

    public synchronized Document buildDocumentFromXml(InputSource inputSource) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputSource);
        if (document == null) {
            throw new RuntimeException("parse produced null document");
        }
        return document;
    }

    public synchronized void writeXML(Document document, Writer writer) throws TransformerException {
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(document), streamResult);
    }

    public static Element position(Element origin, String[] path) {
        Element e = origin;
        for (String p : path) {
            List<Element> children = DocumentUtil.getChildren(e, p);
            if (children == null || children.size() < 1) {
                throw new RuntimeException("Cannot position to <" + p + ">");
            }
            e = children.get(0);
        }
        return e;
    }

    public static List<Element> getChildren(Element element, String tag) {
        NodeList childNodes = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (1 != node.getNodeType() || !node.getNodeName().equals(tag)) continue;
            result.add((Element)node);
        }
        return result;
    }
}

