package ar.com.sdd.edireader.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

public class EdifactData implements Serializable {

    private Long id;
    private String payerCuit;
    private String ownerCuit;
    private String legalDocRef;
    private LocalDate issueDate;
    private LocalDate dueDate;
    private LocalDate creationDate;
    private LocalDate startActivities;
    private LocalDate deliveryDate;
    private double totalAmount;
    private double totalPayable;
    private double dueAmount;
    private double payableAmountNoTax;
    private double totalTaxAmount;
    private List<EdifactItem> edifactItems;
    private List<TaxDescriptionPojo> taxesDescription;
    private String deliveryNumber;
    private String orderNumber;
    private String purchaseOrderNumber;
    private String electronicAuthorizationCode;
    private double tax01;
    private double taxPercentage01;
    private String ediType;



    private String customerNumber;
    private String biltoName;
    private String billingAddress;
    private String shiptoName;
    private String shippingAddress;
    private String ownerAddress;
    private String ownerReasonName;


    public EdifactData() {

    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public LocalDate getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
    }

    public LocalDate getDueDate() {
        return dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public LocalDate getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDate getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(double dueAmount) {
        this.dueAmount = dueAmount;
    }

    public double getPayableAmountNoTax() {
        return payableAmountNoTax;
    }

    public void setPayableAmountNoTax(double payableAmountNoTax) {
        this.payableAmountNoTax = payableAmountNoTax;
    }

    public double getTotalTaxAmount() {
        return totalTaxAmount;
    }

    public void setTotalTaxAmount(double totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public List<EdifactItem> getEdifactItems() {
        return edifactItems;
    }

    public void setEdifactItems(List<EdifactItem> edifactItems) {
        this.edifactItems = edifactItems;
    }

    public String getBiltoName() {
        return biltoName;
    }

    public void setBiltoName(String biltoName) {
        this.biltoName = biltoName;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getShiptoName() {
        return shiptoName;
    }

    public void setShiptoName(String shiptoName) {
        this.shiptoName = shiptoName;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public LocalDate getStartActivities() {
        return startActivities;
    }

    public void setStartActivities(LocalDate startActivities) {
        this.startActivities = startActivities;
    }

    public String getDeliveryNumber() {
        return deliveryNumber;
    }

    public void setDeliveryNumber(String deliveryNumber) {
        this.deliveryNumber = deliveryNumber;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getOwnerAddress() {
        return ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public String getOwnerReasonName() {
        return ownerReasonName;
    }

    public void setOwnerReasonName(String ownerReasonName) {
        this.ownerReasonName = ownerReasonName;
    }

    public String getElectronicAuthorizationCode() {
        return electronicAuthorizationCode;
    }

    public void setElectronicAuthorizationCode(String electronicAuthorizationCode) {
        this.electronicAuthorizationCode = electronicAuthorizationCode;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getPurchaseOrderNumber() {
        return purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public double getTotalPayable() {
        return totalPayable;
    }

    public void setTotalPayable(double totalPayable) {
        this.totalPayable = totalPayable;
    }

    public double getTax01() {
        return tax01;
    }

    public void setTax01(double tax01) {
        this.tax01 = tax01;
    }

    public double getTaxPercentage01() {
        return taxPercentage01;
    }

    public void setTaxPercentage01(double taxPercentage01) {
        this.taxPercentage01 = taxPercentage01;
    }

    public List<TaxDescriptionPojo> getTaxesDescription() {
        return taxesDescription;
    }

    public void setTaxesDescription(List<TaxDescriptionPojo> taxesDescription) {
        this.taxesDescription = taxesDescription;
    }

    public String getEdiType() {
        return ediType;
    }

    public void setEdiType(String ediType) {
        this.ediType = ediType;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EdifactData that = (EdifactData) o;

        if (Double.compare(that.totalAmount, totalAmount) != 0) return false;
        if (Double.compare(that.totalPayable, totalPayable) != 0) return false;
        if (Double.compare(that.dueAmount, dueAmount) != 0) return false;
        if (Double.compare(that.payableAmountNoTax, payableAmountNoTax) != 0) return false;
        if (Double.compare(that.totalTaxAmount, totalTaxAmount) != 0) return false;
        if (Double.compare(that.tax01, tax01) != 0) return false;
        if (Double.compare(that.taxPercentage01, taxPercentage01) != 0) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (payerCuit != null ? !payerCuit.equals(that.payerCuit) : that.payerCuit != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(that.ownerCuit) : that.ownerCuit != null) return false;
        if (legalDocRef != null ? !legalDocRef.equals(that.legalDocRef) : that.legalDocRef != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (creationDate != null ? !creationDate.equals(that.creationDate) : that.creationDate != null) return false;
        if (startActivities != null ? !startActivities.equals(that.startActivities) : that.startActivities != null)
            return false;
        if (deliveryDate != null ? !deliveryDate.equals(that.deliveryDate) : that.deliveryDate != null) return false;
        if (edifactItems != null ? !edifactItems.equals(that.edifactItems) : that.edifactItems != null) return false;
        if (taxesDescription != null ? !taxesDescription.equals(that.taxesDescription) : that.taxesDescription != null)
            return false;
        if (deliveryNumber != null ? !deliveryNumber.equals(that.deliveryNumber) : that.deliveryNumber != null)
            return false;
        if (orderNumber != null ? !orderNumber.equals(that.orderNumber) : that.orderNumber != null) return false;
        if (purchaseOrderNumber != null ? !purchaseOrderNumber.equals(that.purchaseOrderNumber) : that.purchaseOrderNumber != null)
            return false;
        if (electronicAuthorizationCode != null ? !electronicAuthorizationCode.equals(that.electronicAuthorizationCode) : that.electronicAuthorizationCode != null)
            return false;
        if (ediType != null ? !ediType.equals(that.ediType) : that.ediType != null) return false;
        if (customerNumber != null ? !customerNumber.equals(that.customerNumber) : that.customerNumber != null)
            return false;
        if (biltoName != null ? !biltoName.equals(that.biltoName) : that.biltoName != null) return false;
        if (billingAddress != null ? !billingAddress.equals(that.billingAddress) : that.billingAddress != null)
            return false;
        if (shiptoName != null ? !shiptoName.equals(that.shiptoName) : that.shiptoName != null) return false;
        if (shippingAddress != null ? !shippingAddress.equals(that.shippingAddress) : that.shippingAddress != null)
            return false;
        if (ownerAddress != null ? !ownerAddress.equals(that.ownerAddress) : that.ownerAddress != null) return false;
        return ownerReasonName != null ? ownerReasonName.equals(that.ownerReasonName) : that.ownerReasonName == null;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = id != null ? id.hashCode() : 0;
        result = 31 * result + (payerCuit != null ? payerCuit.hashCode() : 0);
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (legalDocRef != null ? legalDocRef.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (creationDate != null ? creationDate.hashCode() : 0);
        result = 31 * result + (startActivities != null ? startActivities.hashCode() : 0);
        result = 31 * result + (deliveryDate != null ? deliveryDate.hashCode() : 0);
        temp = Double.doubleToLongBits(totalAmount);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(totalPayable);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(dueAmount);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(payableAmountNoTax);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(totalTaxAmount);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (edifactItems != null ? edifactItems.hashCode() : 0);
        result = 31 * result + (taxesDescription != null ? taxesDescription.hashCode() : 0);
        result = 31 * result + (deliveryNumber != null ? deliveryNumber.hashCode() : 0);
        result = 31 * result + (orderNumber != null ? orderNumber.hashCode() : 0);
        result = 31 * result + (purchaseOrderNumber != null ? purchaseOrderNumber.hashCode() : 0);
        result = 31 * result + (electronicAuthorizationCode != null ? electronicAuthorizationCode.hashCode() : 0);
        temp = Double.doubleToLongBits(tax01);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(taxPercentage01);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + (ediType != null ? ediType.hashCode() : 0);
        result = 31 * result + (customerNumber != null ? customerNumber.hashCode() : 0);
        result = 31 * result + (biltoName != null ? biltoName.hashCode() : 0);
        result = 31 * result + (billingAddress != null ? billingAddress.hashCode() : 0);
        result = 31 * result + (shiptoName != null ? shiptoName.hashCode() : 0);
        result = 31 * result + (shippingAddress != null ? shippingAddress.hashCode() : 0);
        result = 31 * result + (ownerAddress != null ? ownerAddress.hashCode() : 0);
        result = 31 * result + (ownerReasonName != null ? ownerReasonName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EdifactData ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((startActivities != null) ? "startActivities=" + startActivities + ", " : "")
                + ((deliveryDate != null) ? "deliveryDate=" + deliveryDate + ", " : "")
                + "totalAmount=" + totalAmount + ", "
                + "totalPayable=" + totalPayable + ", "
                + "dueAmount=" + dueAmount + ", "
                + "payableAmountNoTax=" + payableAmountNoTax + ", "
                + "totalTaxAmount=" + totalTaxAmount + ", "
                + ((edifactItems != null) ? "edifactItems=" + Arrays.toString(edifactItems.toArray()) + ", " : "")
                + ((taxesDescription != null) ? "taxesDescription=" + Arrays.toString(taxesDescription.toArray()) + ", " : "")
                + ((deliveryNumber != null) ? "deliveryNumber=" + deliveryNumber + ", " : "")
                + ((orderNumber != null) ? "orderNumber=" + orderNumber + ", " : "")
                + ((purchaseOrderNumber != null) ? "purchaseOrderNumber=" + purchaseOrderNumber + ", " : "")
                + ((electronicAuthorizationCode != null) ? "electronicAuthorizationCode=" + electronicAuthorizationCode + ", " : "")
                + "tax01=" + tax01 + ", "
                + "taxPercentage01=" + taxPercentage01 + ", "
                + ((ediType != null) ? "ediType=" + ediType + ", " : "")
                + ((customerNumber != null) ? "customerNumber=" + customerNumber + ", " : "")
                + ((biltoName != null) ? "biltoName=" + biltoName + ", " : "")
                + ((billingAddress != null) ? "billingAddress=" + billingAddress + ", " : "")
                + ((shiptoName != null) ? "shiptoName=" + shiptoName + ", " : "")
                + ((shippingAddress != null) ? "shippingAddress=" + shippingAddress + ", " : "")
                + ((ownerAddress != null) ? "ownerAddress=" + ownerAddress + ", " : "")
                + ((ownerReasonName != null) ? "ownerReasonName=" + ownerReasonName : "")
                + "]";
    }
}
