/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.benchmark;

import com.berryworks.edireader.benchmark.AnsiUnitOfWork;
import com.berryworks.edireader.benchmark.BenchmarkUnitOfWork;
import com.berryworks.jquantify.EventCounter;
import com.berryworks.jquantify.SessionCounter;

public class Benchmark
implements Runnable {
    private int numberOfThreads;
    private int iterations;
    private int interchangeKCs;
    private SessionCounter iterationCounter;
    private EventCounter charCounter;
    private boolean verbose;

    @Override
    public void run() {
        System.out.println("EDIReader benchmark");
        this.validateParameters();
        System.out.println("  Parsing " + this.iterations + " interchanges");
        System.out.println("  Each interchange approximately " + this.interchangeKCs + " KCs in size");
        System.out.println("  Using " + this.numberOfThreads + (this.numberOfThreads == 1 ? " thread" : " threads"));
        this.iterate();
        if (this.verbose) {
            System.out.println(this.iterationCounter);
        }
        if (this.verbose) {
            System.out.println(this.charCounter);
        }
        long totalChars = this.charCounter.getCumulativeEvents();
        long milliSeconds = this.charCounter.getAgeMillis();
        long charThroughput = (int)this.charCounter.getCumulativeFreq();
        long interchangeThroughput = (long)(this.iterations * 1000) / milliSeconds;
        System.out.println("Results");
        System.out.println("  Actual number of characters parsed: " + totalChars);
        System.out.println("  Number of milliseconds: " + milliSeconds);
        System.out.println("  Parsing throughput:");
        System.out.println("    " + charThroughput + " chars/second");
        System.out.println("    " + interchangeThroughput + " interchanges/second");
        System.out.println("EDIReader benchmark complete");
    }

    protected void iterate() {
        this.iterationCounter = new SessionCounter("Iterations");
        this.charCounter = new EventCounter("Parsed Characters");
        while (this.iterationCounter.getCumulativeEvents() < (long)this.iterations) {
            if (this.iterationCounter.getConcurrency() < (long)this.numberOfThreads) {
                BenchmarkUnitOfWork unitOfWork = this.createUnitOfWork();
                unitOfWork.setSessionCounter(this.iterationCounter);
                unitOfWork.setCharCounter(this.charCounter);
                unitOfWork.setInterchangeKCs(this.interchangeKCs);
                this.iterationCounter.start();
                new Thread(unitOfWork).start();
                if (!this.verbose) continue;
                System.out.println("... " + this.iterationCounter.getCumulativeEvents() + " iterations have now been started");
                continue;
            }
            if (this.verbose) {
                System.out.println("... maximum number of threads active");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.iterationCounter.getConcurrency() > 0L) {
            if (this.verbose) {
                System.out.println("... " + this.iterationCounter.getConcurrency() + " threads still active");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void validateParameters() {
        if (this.numberOfThreads < 1) {
            this.abort("Number of threads must be a positive number");
        }
        if (this.interchangeKCs < 1) {
            this.abort("Interchange size in KCs must be a positive number");
        }
        if (this.iterations < 1) {
            this.abort("Number of iterations must be a positive number");
        }
    }

    protected void abort(String string) {
        System.err.println(string);
        throw new RuntimeException(string);
    }

    protected BenchmarkUnitOfWork createUnitOfWork() {
        return new AnsiUnitOfWork();
    }

    private void setVerbose(boolean b) {
        this.verbose = b;
    }

    public int getInterchangeKCs() {
        return this.interchangeKCs;
    }

    public void setInterchangeKCs(int interchangeKCs) {
        this.interchangeKCs = interchangeKCs;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public static void main(String[] args) {
        Benchmark controller = new Benchmark();
        Benchmark.setDefaults(controller);
        Benchmark.processArgs(args, controller);
        controller.run();
    }

    private static void setDefaults(Benchmark controller) {
        controller.setInterchangeKCs(100);
        controller.setIterations(10);
        controller.setNumberOfThreads(10);
        controller.setVerbose(false);
    }

    private static void processArgs(String[] args, Benchmark controller) {
        block6: for (String arg : args) {
            char c = arg.charAt(0);
            switch (c) {
                case 'v': {
                    controller.setVerbose(true);
                    continue block6;
                }
                case 't': {
                    int n = Benchmark.parseInteger(arg.substring(1));
                    controller.setNumberOfThreads(n);
                    continue block6;
                }
                case 'k': {
                    int n = Benchmark.parseInteger(arg.substring(1));
                    controller.setInterchangeKCs(n);
                    continue block6;
                }
                case 'i': {
                    int n = Benchmark.parseInteger(arg.substring(1));
                    controller.setIterations(n);
                    continue block6;
                }
                default: {
                    Benchmark.badArgs();
                }
            }
        }
    }

    private static int parseInteger(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception e) {
            Benchmark.badArgs();
        }
        return n;
    }

    private static void badArgs() {
        System.err.println("Command line arguments:");
        System.err.println("  t<threads>       where <threads> is the number of concurrent threads");
        System.err.println("  k<kcs>           where <kcs> is the interchange size in 1024-char units");
        System.err.println("  i<interchanges>  where <interchanges> is the number of interchanges to parse");
        System.err.println("  v                verbose output");
        System.err.println("");
        System.err.println("Notes:");
        System.err.println("  All arguments are optional. Default values:");
        System.err.println("    t  10");
        System.err.println("    k  100");
        System.err.println("    i  10");
        System.err.println("    v  false");
        throw new RuntimeException("Missing or invalid command line arguments");
    }
}

