/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.util.CommandLine;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Splitter {
    private static int count;
    private final InputSource inputSource;
    private EDIReader parser;
    private final FileSequenceHandlerFactory handlerFactory;
    private final String newLine = System.getProperty("line.separator");

    public Splitter(Reader inputReader, String outputFileNamePattern) {
        this.inputSource = new InputSource(inputReader);
        this.handlerFactory = new FileSequenceHandlerFactory(outputFileNamePattern);
    }

    public void run() throws IOException, SAXException {
        this.split(this.inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(InputSource inputSource) throws IOException, SAXException {
        char[] leftOver = null;
        try (Writer writer = null;){
            while ((this.parser = EDIReaderFactory.createEDIReader(inputSource, leftOver)) != null) {
                String outputFilename = this.handlerFactory.generateName();
                System.out.println(this.newLine + "EDI interchange written to: " + outputFilename);
                this.parser.setContentHandler(new ScanningHandler());
                writer = new FileWriter(outputFilename);
                this.parser.setCopyWriter(writer);
                this.parser.parse(inputSource);
                writer.close();
                writer = null;
                leftOver = this.parser.getTokenizer().getBuffered();
            }
        }
    }

    public static void main(String[] args) {
        InputStreamReader inputReader;
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        String outputFileNamePattern = commandLine.getOption("o");
        if (outputFileNamePattern == null) {
            Splitter.badArgs();
        }
        if (inputFileName == null) {
            inputReader = new InputStreamReader(System.in);
        } else {
            try {
                inputReader = new InputStreamReader((InputStream)new FileInputStream(inputFileName), "ISO-8859-1");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        Splitter ediSplitter = new Splitter(inputReader, outputFileNamePattern);
        try {
            ediSplitter.run();
        }
        catch (SAXException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void badArgs() {
        System.err.println("Usage: Splitter [inputFile] [-o outputFilenamePattern]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    public static int getCount() {
        return count;
    }

    private static class SyntaxExceptionHandler
    implements EDISyntaxExceptionHandler {
        private SyntaxExceptionHandler() {
        }

        @Override
        public boolean process(RecoverableSyntaxException syntaxException) {
            System.out.println();
            System.out.println("Recoverable syntax exception: " + syntaxException.getClass().getCanonicalName() + " - " + syntaxException.getMessage());
            return true;
        }
    }

    private class ScanningHandler
    extends DefaultHandler {
        private ScanningHandler() {
        }

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
            String indent;
            if (localName.startsWith(Splitter.this.parser.getXMLTags().getInterchangeTag())) {
                indent = "   ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getSenderTag())) {
                System.out.println("  +Sender");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getReceiverTag())) {
                System.out.println("  +Recipient");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getAddressTag())) {
                System.out.println("    +Address");
                indent = "       ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getGroupTag())) {
                System.out.println("  +Group");
                indent = "     ";
            } else if (localName.startsWith(Splitter.this.parser.getXMLTags().getDocumentTag())) {
                System.out.println("    +Document");
                indent = "       ";
            } else {
                return;
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                System.out.println(indent + atts.getLocalName(i) + "=" + atts.getValue(i));
            }
        }
    }

    static class FileSequenceHandlerFactory {
        private String filenameSuffix;
        private String filenamePrefix;
        private int sequenceNumberLength;

        public FileSequenceHandlerFactory(String fileNamePattern) {
            this.establishPattern(fileNamePattern);
        }

        private void establishPattern(String fileNamePattern) {
            String[] splitResult = fileNamePattern.split("0+", 2);
            if (splitResult.length < 2) {
                Splitter.badArgs();
            }
            this.filenamePrefix = splitResult[0];
            this.filenameSuffix = splitResult[1];
            this.sequenceNumberLength = fileNamePattern.length() - this.filenamePrefix.length() - this.filenameSuffix.length();
        }

        private String generateName() {
            Object sequenceDigits = "" + (100000 + ++count);
            sequenceDigits = ((String)sequenceDigits).substring(((String)sequenceDigits).length() - this.sequenceNumberLength);
            return this.filenamePrefix + (String)sequenceDigits + this.filenameSuffix;
        }
    }
}

