/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializableAttributes
extends AttributesImpl
implements Serializable {
    private List<SerializableAttribute> attributes = new ArrayList<SerializableAttribute>();

    public SerializableAttributes(Attributes fromAttributes) {
        if (fromAttributes == null) {
            return;
        }
        for (int i = 0; i < fromAttributes.getLength(); ++i) {
            SerializableAttribute attribute = new SerializableAttribute();
            attribute.setLocalName(fromAttributes.getLocalName(i));
            attribute.setQName(fromAttributes.getQName(i));
            attribute.setType(fromAttributes.getType(i));
            attribute.setURI(fromAttributes.getURI(i));
            attribute.setValue(fromAttributes.getValue(i));
            this.attributes.add(attribute);
        }
    }

    @Override
    public String getURI(int index) {
        return this.attributes.get(index).getURI();
    }

    @Override
    public String getLocalName(int index) {
        return this.attributes.get(index).getLocalName();
    }

    @Override
    public String getQName(int index) {
        return this.attributes.get(index).getQName();
    }

    @Override
    public String getType(int index) {
        return this.attributes.get(index).getType();
    }

    @Override
    public String getValue(int index) {
        return this.attributes.get(index).getValue();
    }

    @Override
    public int getLength() {
        return this.attributes.size();
    }

    @Override
    public void clear() {
        this.attributes = new ArrayList<SerializableAttribute>();
    }

    @Override
    public int getIndex(String uri, String localName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int getIndex(String qName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getType(String uri, String localName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getType(String qName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getValue(String uri, String localName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getValue(String qName) {
        for (SerializableAttribute a : this.attributes) {
            if (!qName.equals(a.getLocalName())) continue;
            return a.getValue();
        }
        return null;
    }

    @Override
    public void setAttributes(Attributes atts) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void addAttribute(String uri, String localName, String qName, String type, String value) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setAttribute(int index, String uri, String localName, String qName, String type, String value) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void removeAttribute(int index) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setURI(int index, String uri) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setLocalName(int index, String localName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setQName(int index, String qName) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setType(int index, String type) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setValue(int index, String value) {
        throw new RuntimeException("not implemented");
    }

    public String toString() {
        Object result = "";
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            String name = this.getQName(i);
            String value = this.getValue(i);
            if (((String)result).length() > 0) {
                result = (String)result + ", ";
            }
            result = (String)result + name + "=" + value;
        }
        return "SerializableAttribute(" + n + "): " + (String)result;
    }

    static class SerializableAttribute
    implements Serializable {
        private String localName;
        private String qName;
        private String type;
        private String uRI;
        private String value;

        SerializableAttribute() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getURI() {
            return this.uRI;
        }

        public void setURI(String uRI) {
            this.uRI = uRI;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = localName;
        }

        public String getQName() {
            return this.qName;
        }

        public void setQName(String qName) {
            this.qName = qName;
        }
    }
}

