/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.splitter.HandlerFactory;
import com.berryworks.edireader.splitter.SplittingHandler;
import com.berryworks.edireader.util.CommandLine;
import com.berryworks.edireader.util.dom.DomBuildingSaxHandler;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EDISplitter {
    private static int count;
    private final InputSource inputSource;
    private HandlerFactory handlerFactory;

    public EDISplitter(Reader inputReader, String outputFileNamePattern) {
        this.inputSource = new InputSource(inputReader);
        this.setHandlerFactory(new FileSequenceHandlerFactory(outputFileNamePattern));
    }

    public void run() throws IOException, SAXException {
        new SplittingHandler(this.handlerFactory).split(this.inputSource);
    }

    public void setHandlerFactory(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public static void main(String[] args) {
        InputStreamReader inputReader;
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        String outputFileNamePattern = commandLine.getOption("o");
        if (outputFileNamePattern == null) {
            EDISplitter.badArgs();
        }
        if (inputFileName == null) {
            inputReader = new InputStreamReader(System.in);
        } else {
            try {
                inputReader = new InputStreamReader((InputStream)new FileInputStream(inputFileName), "ISO-8859-1");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        EDISplitter ediSplitter = new EDISplitter(inputReader, outputFileNamePattern);
        try {
            ediSplitter.run();
        }
        catch (SAXException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e.getMessage());
        }
        String s = System.getProperty("line.separator");
        System.out.print(s + "EDI input parsed into " + count + " XML output files" + s);
    }

    private static void badArgs() {
        System.err.println("Usage: EDISplitter [inputFile] [-o outputFilenamePattern]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    public static int getCount() {
        return count;
    }

    static class FileSequenceHandlerFactory
    implements HandlerFactory {
        private String filenameSuffix;
        private String filenamePrefix;
        private int sequenceNumberLength;
        private DomBuildingSaxHandler saxHandler;

        public FileSequenceHandlerFactory(String fileNamePattern) {
            this.establishPattern(fileNamePattern);
        }

        @Override
        public ContentHandler createDocument() throws Exception {
            ++count;
            this.saxHandler = new DomBuildingSaxHandler();
            return this.saxHandler;
        }

        @Override
        public void closeDocument() throws IOException {
            String xmlFilename = this.generateName();
            System.out.println("Generating XML into file " + xmlFilename);
            DOMSource source = new DOMSource(this.saxHandler.getDocument());
            FileWriter writer = new FileWriter(xmlFilename);
            StreamResult result = new StreamResult(writer);
            try {
                TransformerFactory.newInstance().newTransformer().transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException("Unable to generate XML from DOM");
            }
            finally {
                writer.close();
            }
        }

        @Override
        public void markEndOfStream() {
        }

        private void establishPattern(String fileNamePattern) {
            String[] splitResult = fileNamePattern.split("0+", 2);
            if (splitResult.length < 2) {
                EDISplitter.badArgs();
            }
            this.filenamePrefix = splitResult[0];
            this.filenameSuffix = splitResult[1];
            this.sequenceNumberLength = fileNamePattern.length() - this.filenamePrefix.length() - this.filenameSuffix.length();
        }

        private String generateName() {
            Object sequenceDigits = "" + (100000 + count);
            sequenceDigits = ((String)sequenceDigits).substring(((String)sequenceDigits).length() - this.sequenceNumberLength);
            return this.filenamePrefix + (String)sequenceDigits + this.filenameSuffix;
        }
    }
}

