package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RecurringPaymentDetails implements Serializable {

    @JsonProperty("additionalDetails")
    private AdditionalDetails additionalDetails;

    @JsonProperty("frequency")
    private Frequency frequency;

    @JsonProperty("additionalRecurringData")
    private AdditionalRecurringData additionalRecurringData;


    public AdditionalDetails getAdditionalDetails() {
        return additionalDetails;
    }

    public void setAdditionalDetails(AdditionalDetails additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public Frequency getFrequency() {
        return frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public AdditionalRecurringData getAdditionalRecurringData() {
        return additionalRecurringData;
    }

    public void setAdditionalRecurringData(AdditionalRecurringData additionalRecurringData) {
        this.additionalRecurringData = additionalRecurringData;
    }

    @Override
    public String toString() {
        return "RecurringPaymentDetails [" +
                ((additionalDetails != null) ? "additionalDetails=" + additionalDetails + ", " : "") +
                ((frequency != null) ? "frequency=" + frequency + ", " : "") +
                ((additionalRecurringData != null) ? "additionalRecurringData=" + additionalRecurringData + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RecurringPaymentDetails that = (RecurringPaymentDetails) o;
        return Objects.equals(additionalDetails, that.additionalDetails) && Objects.equals(frequency, that.frequency) && Objects.equals(additionalRecurringData, that.additionalRecurringData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(additionalDetails, frequency, additionalRecurringData);
    }
}