package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RequiredRedirectionData implements Serializable {

    @JsonProperty("url")
    private String url;

    @JsonProperty("headerParameters")
    private HeaderParameters headerParameters;

    @JsonProperty("method")
    private String method;


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HeaderParameters getHeaderParameters() {
        return headerParameters;
    }

    public void setHeaderParameters(HeaderParameters headerParameters) {
        this.headerParameters = headerParameters;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String toString() {
        return "RequiredRedirectionData [" +
                ((url != null) ? "url='" + url + "', " : "") +
                ((headerParameters != null) ? "headerParameters=" + headerParameters + ", " : "") +
                ((method != null) ? "method='" + method + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequiredRedirectionData that = (RequiredRedirectionData) o;
        return Objects.equals(url, that.url) && Objects.equals(headerParameters, that.headerParameters) && Objects.equals(method, that.method);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, headerParameters, method);
    }
}
