package ar.com.sdd.fiservapi.io.secure3d;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthenticationRequest implements Serializable {

    @JsonProperty("authenticationType")
    private String authenticationType;

    @JsonProperty("termURL")
    private String termURL;

    @JsonProperty("methodNotificationURL")
    private String methodNotificationURL;

    @JsonProperty("challengeIndicator")
    private String challengeIndicator;

    @JsonProperty("challengeWindowSize")
    private String challengeWindowSize;

    @JsonProperty("messageCategory")
    private String messageCategory;


    public String getAuthenticationType() {
        return authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getTermURL() {
        return termURL;
    }

    public void setTermURL(String termURL) {
        this.termURL = termURL;
    }

    public String getMethodNotificationURL() {
        return methodNotificationURL;
    }

    public void setMethodNotificationURL(String methodNotificationURL) {
        this.methodNotificationURL = methodNotificationURL;
    }

    public String getChallengeIndicator() {
        return challengeIndicator;
    }

    public void setChallengeIndicator(String challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    public String getChallengeWindowSize() {
        return challengeWindowSize;
    }

    public void setChallengeWindowSize(String challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
    }

    public String getMessageCategory() {
        return messageCategory;
    }

    public void setMessageCategory(String messageCategory) {
        this.messageCategory = messageCategory;
    }

    @Override
    public String toString() {
        return "AuthenticationRequest [" +
                ((authenticationType != null) ? "authenticationType='" + authenticationType + "', " : "") +
                ((termURL != null) ? "termURL='" + termURL + "', " : "") +
                ((methodNotificationURL != null) ? "methodNotificationURL='" + methodNotificationURL + "', " : "") +
                ((challengeIndicator != null) ? "challengeIndicator='" + challengeIndicator + "', " : "") +
                ((challengeWindowSize != null) ? "challengeWindowSize='" + challengeWindowSize + "', " : "") +
                ((messageCategory != null) ? "messageCategory='" + messageCategory + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuthenticationRequest that = (AuthenticationRequest) o;
        return Objects.equals(authenticationType, that.authenticationType) && Objects.equals(termURL, that.termURL) && Objects.equals(methodNotificationURL, that.methodNotificationURL) && Objects.equals(challengeIndicator, that.challengeIndicator) && Objects.equals(challengeWindowSize, that.challengeWindowSize) && Objects.equals(messageCategory, that.messageCategory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticationType, termURL, methodNotificationURL, challengeIndicator, challengeWindowSize, messageCategory);
    }
}
