package ar.com.sdd.fiservapi.model;

import ar.com.sdd.fiservapi.model.response.Components;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionAmount implements Serializable {

    @JsonProperty("total")
    private BigDecimal total;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("components")
    private Components components;

    @JsonProperty("storeId")
    private String storeId;


    public BigDecimal getTotal() {
        return total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Components getComponents() {
        return components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    public String toString() {
        return "TransactionAmount [" +
                ((total != null) ? "total=" + total + ", " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((components != null) ? "components=" + components + ", " : "") +
                ((storeId != null) ? "storeId='" + storeId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TransactionAmount that = (TransactionAmount) o;
        return Objects.equals(total, that.total) && Objects.equals(currency, that.currency) && Objects.equals(components, that.components) && Objects.equals(storeId, that.storeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, currency, components, storeId);
    }
}