package ar.com.sdd.fiservapi.io.secure3d;

import ar.com.sdd.fiservapi.model.secure3d.Secure3dMethod;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthenticationResponse implements Serializable {

    @JsonProperty("type")
    private String type;

    @JsonProperty("version")
    private String version;

    @JsonProperty("secure3dMethod")
    private Secure3dMethod secure3dMethod;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Secure3dMethod getSecure3dMethod() {
        return secure3dMethod;
    }

    public void setSecure3dMethod(Secure3dMethod secure3dMethod) {
        this.secure3dMethod = secure3dMethod;
    }

    @Override
    public String toString() {
        return "AuthenticationResponse [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((version != null) ? "version='" + version + "', " : "") +
                ((secure3dMethod != null) ? "secure3dMethod=" + secure3dMethod + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuthenticationResponse that = (AuthenticationResponse) o;
        return Objects.equals(type, that.type) && Objects.equals(version, that.version) && Objects.equals(secure3dMethod, that.secure3dMethod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, version, secure3dMethod);
    }
}
