package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Receipts implements Serializable {

    public enum Type {
        cardholder,
        merchant
    }

    @JsonProperty("type")
    private Type type;


    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "Receipts [" +
                ((type != null) ? "type=" + type + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Receipts receipts = (Receipts) o;
        return type == receipts.type;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(type);
    }
}