package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentFacilitator implements Serializable {

    @JsonProperty("subMerchantData")
    private SubMerchantData subMerchantData;


    public SubMerchantData getSubMerchantData() {
        return subMerchantData;
    }

    public void setSubMerchantData(SubMerchantData subMerchantData) {
        this.subMerchantData = subMerchantData;
    }

    @Override
    public String toString() {
        return "PaymentFacilitator [" +
                ((subMerchantData != null) ? "subMerchantData=" + subMerchantData + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentFacilitator that = (PaymentFacilitator) o;
        return Objects.equals(subMerchantData, that.subMerchantData);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(subMerchantData);
    }
}
