package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.model.Order;
import ar.com.sdd.fiservapi.model.TransactionAmount;
import ar.com.sdd.fiservapi.model.card.SplitShipment;
import ar.com.sdd.fiservapi.model.PaymentMethod;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentTokenPreAuthTransactionRequest implements Serializable {

    @JsonProperty("ipgTransactionId")
    private Long ipgTransactionId;

    @JsonProperty("merchantTransactionId")
    private String merchantTransactionId;

    @JsonProperty("requestType")
    private String requestType;

    @JsonProperty("transactionAmount")
    private TransactionAmount transactionAmount;

    @JsonProperty("order")
    private Order order;

    @JsonProperty("paymentMethod")
    private PaymentMethod paymentMethod;

    @JsonProperty("splitShipment")
    private SplitShipment splitShipment;


    public Long getIpgTransactionId() {
        return ipgTransactionId;
    }

    public void setIpgTransactionId(Long ipgTransactionId) {
        this.ipgTransactionId = ipgTransactionId;
    }

    public String getMerchantTransactionId() {
        return merchantTransactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public TransactionAmount getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(TransactionAmount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public SplitShipment getSplitShipment() {
        return splitShipment;
    }

    public void setSplitShipment(SplitShipment splitShipment) {
        this.splitShipment = splitShipment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentTokenPreAuthTransactionRequest that = (PaymentTokenPreAuthTransactionRequest) o;
        return Objects.equals(ipgTransactionId, that.ipgTransactionId) && Objects.equals(merchantTransactionId, that.merchantTransactionId) && Objects.equals(requestType, that.requestType) && Objects.equals(transactionAmount, that.transactionAmount) && Objects.equals(order, that.order) && Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(splitShipment, that.splitShipment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipgTransactionId, merchantTransactionId, requestType, transactionAmount, order, paymentMethod, splitShipment);
    }
}
