package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class NetworkToken implements Serializable {

    @JsonProperty("value")
    private String value;

    @JsonProperty("expiryMonth")
    private String expiryMonth;

    @JsonProperty("expiryYear")
    private String expiryYear;

    @JsonProperty("cardLast4")
    private String cardLast4;

    @JsonProperty("brand")
    private String brand;

    @JsonProperty("cryptogram")
    private String cryptogram;


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getExpiryMonth() {
        return expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public String getExpiryYear() {
        return expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public String getCardLast4() {
        return cardLast4;
    }

    public void setCardLast4(String cardLast4) {
        this.cardLast4 = cardLast4;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCryptogram() {
        return cryptogram;
    }

    public void setCryptogram(String cryptogram) {
        this.cryptogram = cryptogram;
    }

    @Override
    public String toString() {
        return "NetworkToken [" +
                ((value != null) ? "value='" + value + "', " : "") +
                ((expiryMonth != null) ? "expiryMonth='" + expiryMonth + "', " : "") +
                ((expiryYear != null) ? "expiryYear='" + expiryYear + "', " : "") +
                ((cardLast4 != null) ? "cardLast4='" + cardLast4 + "', " : "") +
                ((brand != null) ? "brand='" + brand + "', " : "") +
                ((cryptogram != null) ? "cryptogram='" + cryptogram + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkToken that = (NetworkToken) o;
        return Objects.equals(value, that.value) && Objects.equals(expiryMonth, that.expiryMonth) && Objects.equals(expiryYear, that.expiryYear) && Objects.equals(cardLast4, that.cardLast4) && Objects.equals(brand, that.brand) && Objects.equals(cryptogram, that.cryptogram);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, expiryMonth, expiryYear, cardLast4, brand, cryptogram);
    }
}
