package ar.com.sdd.fiservapi.model;

import ar.com.sdd.fiservapi.model.card.PaymentCard;
import ar.com.sdd.fiservapi.model.token.PaymentToken;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentMethod implements Serializable {

    @JsonProperty("paymentToken")
    private PaymentToken paymentToken;

    @JsonProperty("paymentCard")
    private PaymentCard paymentCard;

    @JsonProperty("paymentFacilitator")
    private PaymentFacilitator paymentFacilitator;


    public PaymentToken getPaymentToken() {
        return paymentToken;
    }

    public void setPaymentToken(PaymentToken paymentToken) {
        this.paymentToken = paymentToken;
    }

    public PaymentCard getPaymentCard() {
        return paymentCard;
    }

    public void setPaymentCard(PaymentCard paymentCard) {
        this.paymentCard = paymentCard;
    }

    public PaymentFacilitator getPaymentFacilitator() {
        return paymentFacilitator;
    }

    public void setPaymentFacilitator(PaymentFacilitator paymentFacilitator) {
        this.paymentFacilitator = paymentFacilitator;
    }

    @Override
    public String toString() {
        return "PaymentMethod [" +
                ((paymentToken != null) ? "paymentToken=" + paymentToken + ", " : "") +
                ((paymentCard != null) ? "paymentCard=" + paymentCard + ", " : "") +
                ((paymentFacilitator != null) ? "paymentFacilitator=" + paymentFacilitator + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentMethod that = (PaymentMethod) o;
        return Objects.equals(paymentToken, that.paymentToken) && Objects.equals(paymentCard, that.paymentCard) && Objects.equals(paymentFacilitator, that.paymentFacilitator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentToken, paymentCard, paymentFacilitator);
    }
}
