package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StoredCredentials implements Serializable {

    public enum Sequence {
        FIRST,
        SUBSEQUENT
    }

    @JsonProperty("sequence")
    private Sequence sequence;

    @JsonProperty("scheduled")
    private Boolean scheduled;


    public Sequence getSequence() {
        return sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Boolean getScheduled() {
        return scheduled;
    }

    public void setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
    }

    @Override
    public String toString() {
        return "StoredCredentials [" +
                ((sequence != null) ? "sequence=" + sequence + ", " : "") +
                ((scheduled != null) ? "scheduled=" + scheduled + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StoredCredentials that = (StoredCredentials) o;
        return sequence == that.sequence && Objects.equals(scheduled, that.scheduled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sequence, scheduled);
    }
}
