package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Details implements Serializable {

    @JsonProperty("field")
    private String field;

    @JsonProperty("message")
    private String message;


    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "Details [" +
                ((field != null) ? "field='" + field + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Details details = (Details) o;
        return Objects.equals(field, details.field) && Objects.equals(message, details.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(field, message);
    }
}
