package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.model.response.Error;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonError implements Serializable {

    @JsonProperty("type")
    private String type;

    @JsonProperty("clientRequestId")
    private String clientRequestId;

    @JsonProperty("apiTraceId")
    private String apiTraceId;

    @JsonProperty("responseType")
    private String responseType;

    @JsonProperty("error")
    private Error error;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientRequestId() {
        return clientRequestId;
    }

    public void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }

    public String getApiTraceId() {
        return apiTraceId;
    }

    public void setApiTraceId(String apiTraceId) {
        this.apiTraceId = apiTraceId;
    }

    public String getResponseType() {
        return responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public Error getError() {
        return error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public String toString() {
        return "CommonError [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((clientRequestId != null) ? "clientRequestId='" + clientRequestId + "', " : "") +
                ((apiTraceId != null) ? "apiTraceId='" + apiTraceId + "', " : "") +
                ((responseType != null) ? "responseType='" + responseType + "', " : "") +
                ((error != null) ? "error=" + error + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonError that = (CommonError) o;
        return Objects.equals(type, that.type) && Objects.equals(clientRequestId, that.clientRequestId) && Objects.equals(apiTraceId, that.apiTraceId) && Objects.equals(responseType, that.responseType) && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, clientRequestId, apiTraceId, responseType, error);
    }
}