package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.model.AdditionalDetails;
import ar.com.sdd.fiservapi.model.card.PaymentCard;
import ar.com.sdd.fiservapi.model.response.tokenization.CreateToken;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TokenizationRequest implements Serializable {

    @JsonProperty("requestType")
    private String requestType;

    @JsonProperty("storeId")
    private String storeId;

    @JsonProperty("createToken")
    private CreateToken createToken;

    @JsonProperty("accountVerification")
    private Boolean accountVerification = false;

    @JsonProperty("additionalDetails")
    private AdditionalDetails additionalDetails;

    @JsonProperty("paymentCard")
    private PaymentCard paymentCard;


    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public CreateToken getCreateToken() {
        return createToken;
    }

    public void setCreateToken(CreateToken createToken) {
        this.createToken = createToken;
    }

    public Boolean getAccountVerification() {
        return accountVerification;
    }

    public void setAccountVerification(Boolean accountVerification) {
        this.accountVerification = accountVerification;
    }

    public AdditionalDetails getAdditionalDetails() {
        return additionalDetails;
    }

    public void setAdditionalDetails(AdditionalDetails additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public PaymentCard getPaymentCard() {
        return paymentCard;
    }

    public void setPaymentCard(PaymentCard paymentCard) {
        this.paymentCard = paymentCard;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TokenizationRequest that = (TokenizationRequest) o;
        return Objects.equals(requestType, that.requestType) && Objects.equals(storeId, that.storeId) && Objects.equals(createToken, that.createToken) && Objects.equals(accountVerification, that.accountVerification) && Objects.equals(additionalDetails, that.additionalDetails) && Objects.equals(paymentCard, that.paymentCard);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestType, storeId, createToken, accountVerification, additionalDetails, paymentCard);
    }
}
