package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdditionalRecurringData implements Serializable {

    @JsonProperty("validationIndicator")
    private Boolean validationIndicator = false;


    public Boolean getValidationIndicator() {
        return validationIndicator;
    }

    public void setValidationIndicator(Boolean validationIndicator) {
        this.validationIndicator = validationIndicator;
    }

    @Override
    public String toString() {
        return "AdditionalRecurringData [" +
                ((validationIndicator != null) ? "validationIndicator=" + validationIndicator + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdditionalRecurringData that = (AdditionalRecurringData) o;
        return Objects.equals(validationIndicator, that.validationIndicator);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(validationIndicator);
    }
}
