package ar.com.sdd.fiservapi.model.card;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CardDetails implements Serializable {

    @JsonProperty("brand")
    private String brand;

    @JsonProperty("brandProductId")
    private String brandProductId;

    @JsonProperty("cardFunction")
    private String cardFunction;

    @JsonProperty("commercialCard")
    private String commercialCard;

    @JsonProperty("issuerCountry")
    private String issuerCountry;

    @JsonProperty("issuerName")
    private String issuerName;


    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBrandProductId() {
        return brandProductId;
    }

    public void setBrandProductId(String brandProductId) {
        this.brandProductId = brandProductId;
    }

    public String getCardFunction() {
        return cardFunction;
    }

    public void setCardFunction(String cardFunction) {
        this.cardFunction = cardFunction;
    }

    public String getCommercialCard() {
        return commercialCard;
    }

    public void setCommercialCard(String commercialCard) {
        this.commercialCard = commercialCard;
    }

    public String getIssuerCountry() {
        return issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public String getIssuerName() {
        return issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    @Override
    public String toString() {
        return "CardDetails [" +
                ((brand != null) ? "brand='" + brand + "', " : "") +
                ((brandProductId != null) ? "brandProductId='" + brandProductId + "', " : "") +
                ((cardFunction != null) ? "cardFunction='" + cardFunction + "', " : "") +
                ((commercialCard != null) ? "commercialCard='" + commercialCard + "', " : "") +
                ((issuerCountry != null) ? "issuerCountry='" + issuerCountry + "', " : "") +
                ((issuerName != null) ? "issuerName='" + issuerName + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardDetails that = (CardDetails) o;
        return Objects.equals(brand, that.brand) && Objects.equals(brandProductId, that.brandProductId) && Objects.equals(cardFunction, that.cardFunction) && Objects.equals(commercialCard, that.commercialCard) && Objects.equals(issuerCountry, that.issuerCountry) && Objects.equals(issuerName, that.issuerName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(brand, brandProductId, cardFunction, commercialCard, issuerCountry, issuerName);
    }
}
