package ar.com.sdd.fiservapi.model;

import ar.com.sdd.fiservapi.model.response.Details;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Fault implements Serializable {

    private String faultstring;

    private Details detail;

    public String getFaultstring() {
        return faultstring;
    }

    public void setFaultstring(String faultstring) {
        this.faultstring = faultstring;
    }

    public Details getDetail() {
        return detail;
    }

    public void setDetail(Details detail) {
        this.detail = detail;
    }

    @Override
    public String toString() {
        return "Fault [" +
                ((faultstring != null) ? "faultstring='" + faultstring + "', " : "") +
                ((detail != null) ? "detail=" + detail + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Fault fault = (Fault) o;
        return Objects.equals(faultstring, fault.faultstring) && Objects.equals(detail, fault.detail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(faultstring, detail);
    }
}