package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Details implements Serializable {

    @JsonProperty("field")
    private String field;

    @JsonProperty("message")
    private String message;

    @JsonProperty("errorcode")
    private String errorCode;

    @JsonProperty("reason")
    private String reason;

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return "Details [" +
                ((field != null) ? "field='" + field + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((errorCode != null) ? "errorCode='" + errorCode + "', " : "") +
                ((reason != null) ? "reason='" + reason + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Details details = (Details) o;
        return Objects.equals(field, details.field) && Objects.equals(message, details.message) && Objects.equals(errorCode, details.errorCode) && Objects.equals(reason, details.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(field, message, errorCode, reason);
    }
}