package ar.com.sdd.fiservapi.model.token;

import ar.com.sdd.fiservapi.model.ExpiryDate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentToken implements Serializable {

    public enum Function {
        CREDIT,
        DEBIT,
        PREPAID,
        VOUCHER,
        UNDEFINED
    }

    @JsonProperty("value")
    private String value;

    @JsonProperty("function")
    private Function function;

    @JsonProperty("securityCode")
    private String securityCode;

    @JsonProperty("expiryDate")
    private ExpiryDate expiryDate;

    @JsonProperty("tokenOriginStoreId")
    private String tokenOriginStoreId;


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Function getFunction() {
        return function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public String getSecurityCode() {
        return securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public ExpiryDate getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getTokenOriginStoreId() {
        return tokenOriginStoreId;
    }

    public void setTokenOriginStoreId(String tokenOriginStoreId) {
        this.tokenOriginStoreId = tokenOriginStoreId;
    }

    @Override
    public String toString() {
        return "PaymentToken [" +
                ((value != null) ? "value='" + value + "', " : "") +
                ((function != null) ? "function=" + function + ", " : "") +
                ((securityCode != null) ? "securityCode='" + securityCode + "', " : "") +
                ((expiryDate != null) ? "expiryDate=" + expiryDate + ", " : "") +
                ((tokenOriginStoreId != null) ? "tokenOriginStoreId=" + tokenOriginStoreId + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentToken that = (PaymentToken) o;
        return Objects.equals(value, that.value) && function == that.function && Objects.equals(securityCode, that.securityCode) && Objects.equals(expiryDate, that.expiryDate) && Objects.equals(tokenOriginStoreId, that.tokenOriginStoreId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, function, securityCode, expiryDate, tokenOriginStoreId);
    }
}
