package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdditionalDetails implements Serializable {

    @JsonProperty("operatorId")
    private String operatorId;

    @JsonProperty("salesSystemId")
    private String salesSystemId;

    @JsonProperty("receipts")
    private List<Receipts> receipts;

    @JsonProperty("invoicePeriod")
    private String invoicePeriod;


    public String getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public String getSalesSystemId() {
        return salesSystemId;
    }

    public void setSalesSystemId(String salesSystemId) {
        this.salesSystemId = salesSystemId;
    }

    public List<Receipts> getReceipts() {
        return receipts;
    }

    public void setReceipts(List<Receipts> receipts) {
        this.receipts = receipts;
    }

    public String getInvoicePeriod() {
        return invoicePeriod;
    }

    public void setInvoicePeriod(String invoicePeriod) {
        this.invoicePeriod = invoicePeriod;
    }

    @Override
    public String toString() {
        return "AdditionalDetails [" +
                ((operatorId != null) ? "operatorId='" + operatorId + "', " : "") +
                ((salesSystemId != null) ? "salesSystemId='" + salesSystemId + "', " : "") +
                ((receipts != null) ? "receipts=" + Arrays.toString(receipts.toArray()) + ", " : "") +
                ((invoicePeriod != null) ? "invoicePeriod='" + invoicePeriod + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdditionalDetails that = (AdditionalDetails) o;
        return Objects.equals(operatorId, that.operatorId) && Objects.equals(salesSystemId, that.salesSystemId) && Objects.equals(receipts, that.receipts) && Objects.equals(invoicePeriod, that.invoicePeriod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operatorId, salesSystemId, receipts, invoicePeriod);
    }
}