package ar.com.sdd.fiservapi.model.response.tokenization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class NetworkToken implements Serializable {

    @JsonProperty("value")
    private String value;

    @JsonProperty("expiryMonth")
    private String expiryMonth;

    @JsonProperty("expiryYear")
    private String expiryYear;


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getExpiryMonth() {
        return expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public String getExpiryYear() {
        return expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    @Override
    public String toString() {
        return "NetworkToken [" +
                ((value != null) ? "value='" + value + "', " : "") +
                ((expiryMonth != null) ? "expiryMonth='" + expiryMonth + "', " : "") +
                ((expiryYear != null) ? "expiryYear='" + expiryYear + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkToken that = (NetworkToken) o;
        return Objects.equals(value, that.value) && Objects.equals(expiryMonth, that.expiryMonth) && Objects.equals(expiryYear, that.expiryYear);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, expiryMonth, expiryYear);
    }
}
