package ar.com.sdd.fiservapi.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RequiredConsumerData implements Serializable {

    @JsonProperty("hint")
    private String hint;

    @JsonProperty("validationExpression")
    private String validationExpression;

    @JsonProperty("key")
    private String key;


    public String getHint() {
        return hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getValidationExpression() {
        return validationExpression;
    }

    public void setValidationExpression(String validationExpression) {
        this.validationExpression = validationExpression;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String toString() {
        return "RequiredConsumerData [" +
                ((hint != null) ? "hint='" + hint + "', " : "") +
                ((validationExpression != null) ? "validationExpression='" + validationExpression + "', " : "") +
                ((key != null) ? "key='" + key + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequiredConsumerData that = (RequiredConsumerData) o;
        return Objects.equals(hint, that.hint) && Objects.equals(validationExpression, that.validationExpression) && Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hint, validationExpression, key);
    }
}
