package ar.com.sdd.fiservapi.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CardAccount implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("status")
    private String status;

    @JsonProperty("accountOwnerDescription")
    private String accountOwnerDescription;

    @JsonProperty("billerAccountRef")
    private String billerAccountRef;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAccountOwnerDescription() {
        return accountOwnerDescription;
    }

    public void setAccountOwnerDescription(String accountOwnerDescription) {
        this.accountOwnerDescription = accountOwnerDescription;
    }

    public String getBillerAccountRef() {
        return billerAccountRef;
    }

    public void setBillerAccountRef(String billerAccountRef) {
        this.billerAccountRef = billerAccountRef;
    }

    @Override
    public String toString() {
        return "CardAccount [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((accountOwnerDescription != null) ? "accountOwnerDescription='" + accountOwnerDescription + "', " : "") +
                ((billerAccountRef != null) ? "billerAccountRef='" + billerAccountRef + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardAccount that = (CardAccount) o;
        return Objects.equals(id, that.id) && Objects.equals(status, that.status) && Objects.equals(accountOwnerDescription, that.accountOwnerDescription) && Objects.equals(billerAccountRef, that.billerAccountRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, status, accountOwnerDescription, billerAccountRef);
    }
}
