package ar.com.sdd.fiservapi.server.rest;


import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;
import ar.com.sdd.ebfapi.api.auth.AuthEbfApiService;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/fiservapi/v0_1/auth")
public class AuthApi {

    @Inject
    private AuthEbfApiService authEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return authEbfApiService.postTokenOauth2(applicationId, AuthEbfApiService.OWNER_LOGIN_TYPE.BY_NAME, ownerId, oauthCredentials, securityContext);
    }
}
