/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.fiservapi.server.rest;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.fiservapi.model.card.PaymentCard;
import ar.com.sdd.fiservapi.server.rest.CardApiService;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/fiservapi/v0_1/card")
public class CardApi {
    @Inject
    private CardApiService service;

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment-cards")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response postCard(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, PaymentCard paymentCard, @Context SecurityContext securityContext) {
        return this.service.postCard(authorization, aid, ownerId, paymentCard, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment-cards/{cardId}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteCard(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="cardId") String cardId, @Context SecurityContext securityContext) {
        return this.service.deleteCard(authorization, aid, ownerId, cardId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment-cards")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getCardList(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @QueryParam(value="accountCuit") String accountCuit, @Context SecurityContext securityContext) {
        return this.service.getCardList(authorization, aid, ownerId, accountCuit, securityContext);
    }
}

