package ar.com.sdd.fiservapi.server.rest;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.fiservapi.server.model.PaymentCard;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/fiservapi/v0_1/card")
public class CardApi {

    @Inject
    private CardApiService service;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment-cards")
    @Produces("application/json; charset=UTF-8")
    public Response postCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, PaymentCard paymentCard, @Context SecurityContext securityContext) {
        return service.postCard(authorization, aid, ownerId, paymentCard, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment-cards/{cardId}")
    @Produces("application/json; charset=UTF-8")
    public Response deleteCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("cardId") String cardId, @Context SecurityContext securityContext) {
        return service.deleteCard(authorization, aid, ownerId, cardId, securityContext);
    }

    @PUT
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment-cards/{cardId}")
    @Produces("application/json; charset=UTF-8")
    public Response putCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("cardId") String cardId, PaymentCard paymentCard, @Context SecurityContext securityContext) {
        return service.putCard(authorization, aid, ownerId, cardId, paymentCard, securityContext);
    }
}
