package ar.com.sdd.fiservapi.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentCard implements Serializable {

    @JsonProperty("number")
    private String number;

    @JsonProperty("expiryDate")
    private ExpiryDate expiryDate;

    @JsonProperty("securityCode")
    private String securityCode;


    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public ExpiryDate getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getSecurityCode() {
        return securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    @Override
    public String toString() {
        return "PaymentCard [" +
                ((number != null) ? "number='" + number + "', " : "") +
                ((expiryDate != null) ? "expiryDate=" + expiryDate + ", " : "") +
                ((securityCode != null) ? "securityCode='" + securityCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentCard that = (PaymentCard) o;
        return Objects.equals(number, that.number) && Objects.equals(expiryDate, that.expiryDate) && Objects.equals(securityCode, that.securityCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, expiryDate, securityCode);
    }
}
