package ar.com.sdd.fiservapi.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CardAccount implements Serializable {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("type")
    private String type;

    @JsonProperty("status")
    private String status;

    @JsonProperty("ownerId")
    private String ownerId;

    @JsonProperty("externalReference")
    private String externalReference;

    @JsonProperty("accountOwnerDescription")
    private String accountOwnerDescription;

    @JsonProperty("billerAccountRef")
    private String billerAccountRef;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getAccountOwnerDescription() {
        return accountOwnerDescription;
    }

    public void setAccountOwnerDescription(String accountOwnerDescription) {
        this.accountOwnerDescription = accountOwnerDescription;
    }

    public String getBillerAccountRef() {
        return billerAccountRef;
    }

    public void setBillerAccountRef(String billerAccountRef) {
        this.billerAccountRef = billerAccountRef;
    }

    @Override
    public String toString() {
        return "CardAccount [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((ownerId != null) ? "ownerId='" + ownerId + "', " : "") +
                ((externalReference != null) ? "externalReference='" + externalReference + "', " : "") +
                ((accountOwnerDescription != null) ? "accountOwnerDescription='" + accountOwnerDescription + "', " : "") +
                ((billerAccountRef != null) ? "billerAccountRef='" + billerAccountRef + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardAccount that = (CardAccount) o;
        return Objects.equals(id, that.id) && Objects.equals(type, that.type) && Objects.equals(status, that.status) && Objects.equals(ownerId, that.ownerId) && Objects.equals(externalReference, that.externalReference) && Objects.equals(accountOwnerDescription, that.accountOwnerDescription) && Objects.equals(billerAccountRef, that.billerAccountRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, status, ownerId, externalReference, accountOwnerDescription, billerAccountRef);
    }
}
