package ar.com.sdd.fiservapi.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CardAccountSet implements Serializable {

    private List<CardAccount> cardAccounts = new ArrayList<>();

    public CardAccountSet() {
    }

    @JsonProperty("cardAccounts")
    public List<CardAccount> getCardAccounts() {
        return cardAccounts;
    }

    public void setCardAccounts(List<CardAccount> cardAccounts) {
        this.cardAccounts = cardAccounts;
    }

    @Override
    public String toString() {
        return "CardAccountSet [" +
                ((cardAccounts != null) ? "cardAccounts=" + Arrays.toString(cardAccounts.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardAccountSet that = (CardAccountSet) o;
        return Objects.equals(cardAccounts, that.cardAccounts);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(cardAccounts);
    }
}
