package ar.com.sdd.fiservapi.server.rest;


import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/fiservapi/v1_2/auth")
public class AuthApi {

    @Inject
    private AuthApiService service;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return service.postTokenOauth2(applicationId, ownerId, oauthCredentials, securityContext);
    }
}
