package ar.com.sdd.fiservapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.ThreadUtil;
import ar.com.sdd.fiservapi.io.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@SuppressWarnings("unused")
public class FiservApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(FiservApiConnector.class);

    private final RestConnector restConnector;
    // TODO: Por ahora dejo estos, no se si cambian
    private final String accessTokenBaseUrl;
    private final String clientId;
    private final String username;
    private final String password;

    private final static int MAX_RETRIES = 3;
    private final static int RETRY_WAIT_MILIS = 200;

    public FiservApiConnector(FiservApiConnectorContext context) {
        this.accessTokenBaseUrl = context.getAccessTokenBaseUrl();
        this.clientId = context.getClientId();
        this.username = context.getUsername();
        this.password = context.getPassword();

        log.trace("Creando FiservApiConnector para url [{}]", context.getBaseUrl());

        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    /*
        |==== METODOS ACTUALES ====|

        - Creacion de Transacciones:
            - createPaymentCardCreditTransaction
            - createPaymentCardPayerAuthTransaction
            - createPaymentCardPreAuthTransaction
            - createPaymentCardSaleTransaction
            - createPaymentTokenCreditTransaction
            - createPaymentTokenPreAuthTransaction
            - createPaymentTokenSaleTransaction (Segun documentacion queremos usar este por el momento)

         - Consulta Status de Transacciones:
            - getPaymentCardCreditTransactionStatus
            - getPaymentCardPayerAuthTransactionStatus
            - getPaymentCardPreAuthTransactionStatus
            - getPaymentCardSaleTransactionStatus
            - getPaymentTokenCreditTransactionStatus
            - getPaymentTokenPreAuthTransactionStatus
            - getPaymentTokenSaleTransactionStatus (Segun documentacion queremos usar este por el momento)
    */

    public CommonResponse createPaymentCardCreditTransaction(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentCardCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardCreditTransactionStatus(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardPayerAuthTransaction(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentCardPayerAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardPayerAuthTransactionStatus(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPayerAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardPreAuthTransaction(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentCardPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardPreAuthTransactionStatus(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardSaleTransaction(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentCardSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardSaleTransactionStatus(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenCreditTransaction(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentTokenCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenCreditTransactionStatus(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenPreAuthTransaction(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentTokenPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenPreAuthTransactionStatus(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenSaleTransaction(PaymentTokenSaleTransactionRequest request) throws RestConnectorException {
        final String path = "/payments";
        log.debug("[createPaymentTokenSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericPost(request, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenSaleTransactionStatus(PaymentTokenSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", request, path);

        RestConnectorException lastException = null;
        for (int retry = MAX_RETRIES; retry > 0; retry--) {
            try {
                return restConnector.genericGet(null, CommonResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
            } catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    getAccessToken(true);
                }
            }
            ThreadUtil.sleep(RETRY_WAIT_MILIS);
        }
        throw lastException;
    }

    public PaymentCardPaymentTokenizationResponse createCardPaymentTokenization(PaymentCardPaymentTokenizationRequest request) throws RestConnectorException {
        final String path = "/payment-tokens";
        log.debug("[createPaymentToken] Request POST por la creacion de un token, request [{}] path [{}]", request, path);
        PaymentCardPaymentTokenizationResponse response = restConnector.genericPost(request, PaymentCardPaymentTokenizationResponse.class, path, MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);
        log.debug("[createPaymentToken] Response POST por la creacion de un token, response [{}]", response);
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", "Bearer " + getAccessToken(false));
        }
        return builder;
    }

    // TODO: No sabemos como se va a obtener el accessToken, por ahora queda asi. Cuando confirmen lo cambiamos
    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(FiservApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey("accessToken");
        String accessToken = (String) cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("client_id", clientId);
            form.param("username", username);
            form.param("password", password);
            form.param("grant_type", "password");

            log.debug("[getAccessToken] Por recuperar token con client_id [{}], username [{}] y password [{}]", clientId, username, password);

            RestConnector connector = new RestConnector(new RestConnectorEnvironment(accessTokenBaseUrl), null);
            TokenOAuth2 tokenOAuth2Response = connector.genericPost(form, TokenOAuth2.class, "/auth/realms/WebTarjeta/protocol/openid-connect/token", MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);

            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", tokenOAuth2Response, tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, accessToken, tokenOAuth2Response.getExpiresIn() - 10);
        }

        return accessToken;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}
