package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdditionalDetails implements Serializable {

    @JsonProperty("receipts")
    private List<Receipts> receipts;

    public List<Receipts> getReceipts() {
        return receipts;
    }

    public void setReceipts(List<Receipts> receipts) {
        this.receipts = receipts;
    }

    @Override
    public String toString() {
        return "AdditionalDetails [" +
                ((receipts != null) ? "receipts=" + Arrays.toString(receipts.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdditionalDetails that = (AdditionalDetails) o;
        return Objects.equals(receipts, that.receipts);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(receipts);
    }
}