/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.fiservapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.ThreadUtil;
import ar.com.sdd.fiservapi.core.FiservApiConnectorContext;
import ar.com.sdd.fiservapi.io.CommonResponse;
import ar.com.sdd.fiservapi.io.PaymentCardCreditTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPayerAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPaymentTokenizationRequest;
import ar.com.sdd.fiservapi.io.PaymentCardPaymentTokenizationResponse;
import ar.com.sdd.fiservapi.io.PaymentCardPreAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentCardSaleTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenCreditTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenPreAuthTransactionRequest;
import ar.com.sdd.fiservapi.io.PaymentTokenSaleTransactionRequest;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FiservApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(FiservApiConnector.class);
    private final RestConnector restConnector;
    private final String accessTokenBaseUrl;
    private final String clientId;
    private final String username;
    private final String password;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;

    public FiservApiConnector(FiservApiConnectorContext context) {
        this.accessTokenBaseUrl = context.getAccessTokenBaseUrl();
        this.clientId = context.getClientId();
        this.username = context.getUsername();
        this.password = context.getPassword();
        log.trace("Creando FiservApiConnector para url [{}]", (Object)context.getBaseUrl());
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CommonResponse createPaymentCardCreditTransaction(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardCreditTransactionStatus(PaymentCardCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardPayerAuthTransaction(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardPayerAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardPayerAuthTransactionStatus(PaymentCardPayerAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPayerAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardPreAuthTransaction(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardPreAuthTransactionStatus(PaymentCardPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentCardSaleTransaction(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentCardSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentCardSaleTransactionStatus(PaymentCardSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentCardSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenCreditTransaction(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentTokenCreditTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenCreditTransactionStatus(PaymentTokenCreditTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenCreditTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenPreAuthTransaction(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentTokenPreAuthTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenPreAuthTransactionStatus(PaymentTokenPreAuthTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenPreAuthTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse createPaymentTokenSaleTransaction(PaymentTokenSaleTransactionRequest request) throws RestConnectorException {
        String path = "/payments";
        log.debug("[createPaymentTokenSaleTransaction] Request POST por creacion de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/payments");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericPost((Object)request, CommonResponse.class, "/payments", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public CommonResponse getPaymentTokenSaleTransactionStatus(PaymentTokenSaleTransactionRequest request) throws RestConnectorException {
        String transactionId = String.valueOf(request.getIpgTransactionId());
        String path = "/payments/" + transactionId;
        log.debug("[getPaymentTokenSaleTransactionStatus] Request GET por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)path);
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (CommonResponse)this.restConnector.genericGet(null, CommonResponse.class, path, "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public PaymentCardPaymentTokenizationResponse createCardPaymentTokenization(PaymentCardPaymentTokenizationRequest request) throws RestConnectorException {
        String path = "/payment-tokens";
        log.debug("[createPaymentToken] Request POST por la creacion de un token, request [{}] path [{}]", (Object)request, (Object)"/payment-tokens");
        PaymentCardPaymentTokenizationResponse response = (PaymentCardPaymentTokenizationResponse)this.restConnector.genericPost((Object)request, PaymentCardPaymentTokenizationResponse.class, "/payment-tokens", "application/json", "application/x-www-form-urlencoded");
        log.debug("[createPaymentToken] Response POST por la creacion de un token, response [{}]", (Object)response);
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
        }
        return builder;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(FiservApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("client_id", this.clientId);
            form.param("username", this.username);
            form.param("password", this.password);
            form.param("grant_type", "password");
            log.debug("[getAccessToken] Por recuperar token con client_id [{}], username [{}] y password [{}]", (Object)this.clientId, (Object)this.username, (Object)this.password);
            RestConnector connector = new RestConnector(new RestConnectorEnvironment(this.accessTokenBaseUrl), null);
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/auth/realms/WebTarjeta/protocol/openid-connect/token", "application/json", "application/x-www-form-urlencoded");
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

