package ar.com.sdd.fiservapi.io;

import ar.com.sdd.fiservapi.model.AdditionalDetails;
import ar.com.sdd.fiservapi.model.card.PaymentCard;
import ar.com.sdd.fiservapi.model.response.tokenization.CreateToken;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentCardPaymentTokenizationRequest implements Serializable {

    @JsonProperty("requestType")
    private String requestType;

    @JsonProperty("createToken")
    private CreateToken createToken;

    @JsonProperty("accountVerification")
    private Boolean accountVerification = false;

    @JsonProperty("additionalDetails")
    private AdditionalDetails additionalDetails;

    @JsonProperty("paymentCard")
    private PaymentCard paymentCard;


    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public CreateToken getCreateToken() {
        return createToken;
    }

    public void setCreateToken(CreateToken createToken) {
        this.createToken = createToken;
    }

    public Boolean getAccountVerification() {
        return accountVerification;
    }

    public void setAccountVerification(Boolean accountVerification) {
        this.accountVerification = accountVerification;
    }

    public AdditionalDetails getAdditionalDetails() {
        return additionalDetails;
    }

    public void setAdditionalDetails(AdditionalDetails additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public PaymentCard getPaymentCard() {
        return paymentCard;
    }

    public void setPaymentCard(PaymentCard paymentCard) {
        this.paymentCard = paymentCard;
    }

    @Override
    public String toString() {
        return "PaymentCardPaymentTokenizationRequest [" +
                ((requestType != null) ? "requestType='" + requestType + "', " : "") +
                ((createToken != null) ? "createToken=" + createToken + ", " : "") +
                ((accountVerification != null) ? "accountVerification=" + accountVerification + ", " : "") +
                ((additionalDetails != null) ? "additionalDetails=" + additionalDetails + ", " : "") +
                ((paymentCard != null) ? "paymentCard=" + paymentCard + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentCardPaymentTokenizationRequest that = (PaymentCardPaymentTokenizationRequest) o;
        return Objects.equals(requestType, that.requestType) && Objects.equals(createToken, that.createToken) && Objects.equals(accountVerification, that.accountVerification) && Objects.equals(additionalDetails, that.additionalDetails) && Objects.equals(paymentCard, that.paymentCard);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestType, createToken, accountVerification, additionalDetails, paymentCard);
    }
}
