package ar.com.sdd.fiservapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BancontactQR implements Serializable {

    public enum TransactionRoutingMeans {
        QR_CODE("QR Code"),
        URL_INTENT("URL Intent");

        private final String displayName;

        TransactionRoutingMeans(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String toString() {
            return displayName;
        }
    }

    @JsonProperty("transactionRoutingMeans")
    private TransactionRoutingMeans transactionRoutingMeans;


    public TransactionRoutingMeans getTransactionRoutingMeans() {
        return transactionRoutingMeans;
    }

    public void setTransactionRoutingMeans(TransactionRoutingMeans transactionRoutingMeans) {
        this.transactionRoutingMeans = transactionRoutingMeans;
    }

    @Override
    public String toString() {
        return "BancontactQR [" +
                ((transactionRoutingMeans != null) ? "transactionRoutingMeans=" + transactionRoutingMeans + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BancontactQR that = (BancontactQR) o;
        return transactionRoutingMeans == that.transactionRoutingMeans;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(transactionRoutingMeans);
    }
}